/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.test;

import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.history.util.WeightedMedian;

public class TestWeightedMedian {

	public static void main(String[] args) throws Exception {
		
	    WeightedMedian median = new WeightedMedian(5);
	    
	    median.add(1, 1);
	    System.out.println(median);
	    median.add(1, 2);
	    System.out.println(median);
	    median.add(1, 3);
	    System.out.println(median);
	    median.add(1, 4);
	    System.out.println(median);
	    median.add(1, 4);
	    System.out.println(median);
	    median.add(1, 4);
	    System.out.println(median);
	    median.add(10, -1);
	    System.out.println(median);
	    median.add(10, 10);
	    System.out.println(median);

	    System.out.println();
	    median.clear();
	    for (int i = 1; i < 10; i += 2) {
	    	median.add(1.0, i);
	        System.out.println(median);
	    }

	    for (int i = 10; i >= 2; i -= 2) {
	    	median.add(1.0, i);
	        System.out.println(median);
	    }

	    System.out.println();
        System.out.println(median);
	    
	    Binding b = Bindings.getBinding( WeightedMedian.class );

	    WeightedMedian qu = (WeightedMedian) b.createDefault();
	    qu.add( 5.0, 5.0 );
	    
	    Serializer s = Bindings.getSerializerUnchecked( b );
	    byte[] data = s.serialize( median );
	    System.out.println(Arrays.toString(data));
	    WeightedMedian q2 = (WeightedMedian) s.deserialize( data );
	    System.out.println( b.toString(q2) );
	    
	    System.out.println();
	    
	}
	
	
}
