package org.simantics.history;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;

/**
 * (Utility Class) Item format for HistoryItem.
 *
 * @author toni.kalajainen@semantum.fi
 */
public class HistoryItem extends Bean.Id  {

	/** 
	 * Unique identifier of the item.
	 */
	public @Identifier String id;
	
	/** 
	 * Describes the format of the packed sample. The sample must be a record.
	 * The record must have any combination of the following named fields.
	 * The field types must one of: byte, integer, long, float, double.
	 * 
	 * time, endTime, value - are mandatory fields.
	 * 
	 *  time      -  Region start time, the time of the 1st sample included into the band
	 *  endTime   -  Region end time, the time of the last sample included into the band
	 *  
	 *  value     -  First value in the band
	 *  lastValue -  Last value in the band
	 *  avg       -  Average value of all included samples
	 *  median    -  Median value of all samples in the band
	 *  min       -  Lowest value in the band
	 *  max       -  Highest value in the band
	 *  
	 *  quality   -  0 = Good, -1 = No value
	 *  count     -  The number of included samples in the band
	 */
	public Datatype format;
	
	public HistoryItem(String id, Datatype format) {
		super();
		this.id = id;
		this.format = format;
	}
	
}
