package org.simantics.history.examples;

import java.util.UUID;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryAndCollectorItem;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryItem;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.FlushPolicy;

public class CollectorExample2 {

	public static void main(String[] args) throws HistoryException, BindingException, AccessorException {
		
		/// Example2: Record variable "MyVariable" to two history  
		///           items "MyVariable-interval=0.5" and "MyVariable-deadband=5"
		
		// Create History Manager
		HistoryManager history = History.createMemoryHistory();
		
		// Create a sample format
		RecordType sampleFormat = new RecordType();
		sampleFormat.addComponent("time", Datatypes.DOUBLE );
		sampleFormat.addComponent("value", Datatypes.DOUBLE );
		sampleFormat.addComponent("quality", Datatypes.BYTE );
		
		// Create two History Item and Collector Item configurations
		HistoryAndCollectorItem i1 = new HistoryAndCollectorItem();
		i1.id = "MyVariable-interval=0.5";
		i1.format = sampleFormat;
		i1.interval = 0.5;
		i1.variableId = "MyVariable";
		
		HistoryAndCollectorItem i2 = new HistoryAndCollectorItem();
		i2.id = "MyVariable-deadband=5";
		i2.format = sampleFormat;
		i2.deadband = 5.0;
		i2.variableId = "MyVariable";

		// Create the item in the history
		history.create( i1, i2 );

		/// Prepare Collector
		Collector collector = History.createCollector(history, FlushPolicy.NoFlush);
		
		// Initialize Collector (Items)
		collector.addItem( i1 );
		collector.addItem( i2 );
		
		try {
			// Simulate 100 steps
			for ( int i = 0; i<100; i++ ) {
				
				// Our "simulation" results 
				double time = i * 0.1;
				double myItemValue = -20 + i*0.1;
				
				// Begin collector writing step
				collector.beginStep(Bindings.DOUBLE, time);
				
				// Enter values for one variable. 
				collector.setValue("MyVariable", Bindings.DOUBLE, myItemValue);
				
				// End collector step - MyVariable is written to two HistoryItems
				collector.endStep();
			}
			
		} finally {
			// Flush values
			collector.flush();
			collector.close();
		}
				
	}

}
