/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.help.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.help.core.HelpUtils;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;

public class HelpFileDocumentProvider
extends AbstractDocumentProvider {
    private Resource resource;
    private String currentText;
    private boolean errorHappened;

    protected IDocument createDocument(Object element) throws CoreException {
        IResourceEditorInput input = (IResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    HelpFileDocumentProvider.this.currentText = HelpUtils.readHelpFileContents((ReadGraph)graph, (Resource)HelpFileDocumentProvider.this.resource);
                    HelpFileDocumentProvider.this.errorHappened = false;
                    return new Document(HelpFileDocumentProvider.this.currentText != null ? HelpFileDocumentProvider.this.currentText : "");
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = true;
            return new Document(sw.toString());
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog((String)"HelpFileDocumentProvider.doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                HelpUtils.saveHelpFileContents((WriteGraph)graph, (Resource)HelpFileDocumentProvider.this.resource, (String)HelpFileDocumentProvider.this.currentText);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved SCL Module " + graph.getRelatedValue2(HelpFileDocumentProvider.this.resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
            }
        });
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.errorHappened;
    }

    public boolean isReadOnly(Object element) {
        return this.errorHappened;
    }

    public boolean canSaveDocument(Object element) {
        return !this.errorHappened && !this.getDocument(element).get().equals(this.currentText);
    }
}

