/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.help.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocContribution;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.help.core.HelpUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class SimanticsTocProvider
extends AbstractTocProvider {
    private static DocumentBuilder builder;
    private static Document document;
    private static Map<String, Path> widgetReferences;
    private static Map<String, List<Path>> tutorials;

    public ITocContribution[] getTocContributions(String locale) {
        String libName;
        ArrayList<TocContribution> contributions = new ArrayList<TocContribution>();
        if (widgetReferences == null || tutorials == null) {
            try {
                Simantics.getSession().syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        widgetReferences = HelpUtils.collectWidgetReferencesFromSharedLibraries(graph);
                        tutorials = HelpUtils.collectHelpsFromSharedLibraries(graph);
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Toc> tocs = new HashMap<String, Toc>();
        if (widgetReferences != null) {
            for (Map.Entry<String, Iterable<Path>> entry : widgetReferences.entrySet()) {
                libName = entry.getKey();
                Path htmlFile = (Path)entry.getValue();
                Toc toc = (Toc)tocs.get(libName);
                if (toc == null) {
                    Element element = SimanticsTocProvider.getDocument().createElement("toc");
                    toc = new Toc(element);
                    toc.setLabel(libName);
                    tocs.put(libName, toc);
                }
                Topic topic = new Topic();
                topic.setLabel("Widget Reference");
                String href = htmlFile.toString().split("org.simantics.help.core")[1].substring(1);
                href = "PLUGINS_ROOT/platform:/meta/org.simantics.help.core/" + href;
                topic.setHref(href.replace("\\", "/").replace(" ", "%20"));
                toc.appendChild((UAElement)topic);
            }
        }
        if (tutorials != null) {
            for (Map.Entry<String, Iterable<Path>> entry : tutorials.entrySet()) {
                libName = entry.getKey();
                Toc toc = (Toc)tocs.get(libName);
                if (toc == null) {
                    Element element = SimanticsTocProvider.getDocument().createElement("toc");
                    toc = new Toc(element);
                    toc.setLabel(libName);
                    toc.setTopic(libName);
                    toc.setHref(libName);
                    tocs.put(libName, toc);
                }
                HashMap<String, Topic> topics = new HashMap<String, Topic>();
                for (Path htmlFile : (List)entry.getValue()) {
                    Path path = Paths.get(htmlFile.toString().split(libName)[1], new String[0]);
                    Topic topic = SimanticsTocProvider.getOrCreateTopic(topics, toc, path);
                    String href = htmlFile.toString().split("org.simantics.help.core")[1].substring(1);
                    href = "PLUGINS_ROOT/platform:/meta/org.simantics.help.core/" + href;
                    topic.setHref(href.replace("\\", "/").replace(" ", "%20"));
                }
            }
        }
        for (Toc toc : tocs.values()) {
            TocContribution contribution = new TocContribution();
            contribution.setLocale(locale);
            contribution.setId(toc.getLabel());
            contribution.setCategoryId("category_" + toc.getLabel());
            contribution.setPrimary(true);
            contribution.setContributorId("org.simantics.help.core");
            contribution.setExtraDocuments(new String[0]);
            contribution.setToc(toc);
            contributions.add(contribution);
        }
        return contributions.toArray(new ITocContribution[contributions.size()]);
    }

    private static Topic getOrCreateTopic(Map<String, Topic> topics, Toc toc, Path topicPath) {
        String topicName = topicPath.getFileName().toString();
        Topic topic = topics.get(topicName);
        if (topic == null) {
            topic = new Topic();
            topic.setLabel(topicName);
            Path parentPath = topicPath.getParent();
            if (parentPath != null && parentPath.getFileName() != null) {
                Topic parentTopic = SimanticsTocProvider.getOrCreateTopic(topics, toc, parentPath);
                parentTopic.appendChild((UAElement)topic);
            } else {
                toc.appendChild((UAElement)topic);
            }
            topics.put(topicName, topic);
        }
        return topic;
    }

    private static Document getDocument() {
        if (document == null) {
            if (builder == null) {
                try {
                    builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    builder.setEntityResolver((EntityResolver)new LocalEntityResolver());
                }
                catch (ParserConfigurationException e) {
                    String msg = "Error creating document builder";
                    HelpPlugin.logError((String)msg, (Throwable)e);
                }
            }
            document = builder.newDocument();
        }
        return document;
    }

    public static void clearTocCache() {
        widgetReferences.clear();
        widgetReferences = null;
        tutorials.clear();
        tutorials = null;
        HelpPlugin.getTocManager().clearCache();
    }
}

