/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.help.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.mylyn.wikitext.mediawiki.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.help.HelpResources;
import org.simantics.help.core.Activator;
import org.simantics.help.core.SimanticsTocProvider;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.structural.stubs.StructuralResource2;
import winterwell.markdown.pagemodel.MarkdownPage;

public class HelpUtils {
    public static Resource createHelpLibrary(WriteGraph graph, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HelpResources HELP = HelpResources.getInstance((ReadGraph)graph);
        Resource library = graph.newResource();
        graph.claim(library, L0.InstanceOf, null, HELP.HelpLibrary);
        graph.addLiteral(library, L0.HasName, L0.NameOf, (Object)"Help Library", (Binding)Bindings.STRING);
        graph.claim(parent, L0.ConsistsOf, L0.PartOf, library);
        return library;
    }

    public static Resource createHelpTutorial(WriteGraph graph, Resource parent, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HelpResources HELP = HelpResources.getInstance((ReadGraph)graph);
        Resource tutorialFile = graph.newResource();
        graph.claim(tutorialFile, L0.InstanceOf, null, HELP.TutorialFile);
        graph.addLiteral(tutorialFile, L0.HasName, L0.NameOf, (Object)name, (Binding)Bindings.STRING);
        graph.claim(parent, L0.ConsistsOf, L0.PartOf, tutorialFile);
        return tutorialFile;
    }

    public static List<Path> collectHelps(ReadGraph graph, Resource indexRoot) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HelpResources HELP = HelpResources.getInstance((ReadGraph)graph);
        List tutorialFiles = ModelingUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)HELP.TutorialFile);
        if (tutorialFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Path> result = new ArrayList<Path>(tutorialFiles.size());
        for (Resource tutorialFile : tutorialFiles) {
            StringBuilder sb = new StringBuilder();
            HelpUtils.htmlHead(sb, (String)graph.getRelatedValue2(tutorialFile, L0.HasName, (Binding)Bindings.STRING));
            sb.append(HelpUtils.markdownToHtml(graph, tutorialFile));
            HelpUtils.htmlHeadClose(sb);
            String indexRootURI = graph.getURI(indexRoot);
            String indexRootName = (String)graph.getRelatedValue2(indexRoot, L0.HasName, (Binding)Bindings.STRING);
            String tutorialFileURI = graph.getURI(tutorialFile);
            String suffix = tutorialFileURI.substring(indexRootURI.length());
            try {
                if (suffix.startsWith("/")) {
                    suffix = suffix.substring(1);
                }
                suffix = URLDecoder.decode(suffix, StandardCharsets.UTF_8.name());
                Path outputPath = Activator.getHtmlDirectory().resolve(indexRootName).resolve(String.valueOf(suffix) + ".html");
                HelpUtils.createDirsRec(outputPath.getParent());
                if (!Files.exists(outputPath, new LinkOption[0])) {
                    Files.createFile(outputPath, new FileAttribute[0]);
                }
                Files.write(outputPath, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                result.add(outputPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void createDirsRec(Path path) throws IOException {
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            HelpUtils.createDirsRec(parent);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public static Map<String, List<Path>> collectHelpsFromSharedLibraries(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection sharedLibraries = (Collection)graph.syncRequest((Read)new ObjectsWithType(graph.getRootLibrary(), L0.ConsistsOf, L0.SharedOntology));
        if (sharedLibraries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Path>> result = new HashMap<String, List<Path>>(sharedLibraries.size());
        for (Resource library : sharedLibraries) {
            String libraryName = (String)graph.getRelatedValue2(library, L0.HasName, (Binding)Bindings.STRING);
            List<Path> paths = HelpUtils.collectHelps(graph, library);
            result.put(libraryName, paths);
        }
        return result;
    }

    public static Map<String, Path> collectWidgetReferencesFromSharedLibraries(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection sharedLibraries = (Collection)graph.syncRequest((Read)new ObjectsWithType(graph.getRootLibrary(), L0.ConsistsOf, L0.SharedOntology));
        if (sharedLibraries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Path> result = new HashMap<String, Path>(sharedLibraries.size());
        for (Resource library : sharedLibraries) {
            String html = HelpUtils.createWidgetReference(graph, library, "Widget Reference");
            String indexRootName = (String)graph.getRelatedValue2(library, L0.HasName, (Binding)Bindings.STRING);
            try {
                Path outputPath = Activator.getHtmlDirectory().resolve(indexRootName).resolve("widgetReference.html");
                HelpUtils.createDirsRec(outputPath.getParent());
                if (!Files.exists(outputPath, new LinkOption[0])) {
                    Files.createFile(outputPath, new FileAttribute[0]);
                }
                Files.write(outputPath, html.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                result.put(indexRootName, outputPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void htmlHead(StringBuilder sb, String title) {
        sb.append("<!DOCTYPE html PUBLIC \"-//IETF//DTD HTML//EN\">\n");
        sb.append("<html><head><title>" + title + " Tutorial</title>\n");
        sb.append("<link rel=\"Stylesheet\" type=\"text/css\" media=\"all\" href=\"../style.css\">\n");
        sb.append("</head>\n");
        sb.append("<body style=\"background-color: white;\">\n");
        sb.append("<h1 align=\"center\">" + title + "</h1>\n");
        sb.append("<hr>\n");
    }

    private static void htmlHeadClose(StringBuilder sb) {
        sb.append("</body></html>\n");
    }

    public static String createWidgetReference(ReadGraph graph, Resource indexRoot, String title) throws DatabaseException {
        String ontologyDesc = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)indexRoot);
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html PUBLIC \"-//IETF//DTD HTML//EN\">\n");
        sb.append("<html><head><title>" + ontologyDesc + " Widget Reference</title>\n");
        sb.append("<link rel=\"Stylesheet\" type=\"text/css\" media=\"all\" href=\"../style.css\">\n");
        sb.append("</head>\n");
        sb.append("<body style=\"background-color: white;\">\n");
        sb.append("<h1 align=\"center\">" + ontologyDesc + "</h1>\n");
        sb.append("<h2 align=\"center\">Widget Reference</h2>\n");
        sb.append("<hr>\n");
        sb.append("<h1 align=\"center\">" + title + "</h1>\n");
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        List types = ModelingUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)DOC.DocumentComponentType);
        for (Resource type : types) {
            String label = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)type);
            sb.append("<h2><a name=\"" + label + "\"></a>" + label + "</h2>\n");
            sb.append("<h3>Description</h3>\n");
            String desc = (String)graph.getPossibleRelatedValue(type, L0.HasDescription);
            if (desc == null) {
                desc = "";
            }
            sb.append("<p>" + WikiParser.parseToHtml(desc, false) + "</p>\n");
            sb.append("<h3>Base Types</h3>\n");
            HashMap<String, String> names = new HashMap<String, String>();
            for (Resource resource : graph.getSupertypes(type)) {
                if (!graph.isInheritedFrom(resource, STR.Component)) continue;
                String label2 = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)resource);
                String name = (String)graph.getRelatedValue(resource, L0.HasName);
                if ("Element".equals(name) || "DefinedElement".equals(name) || "PrimitiveComponent".equals(name) || "DocumentComponent".equals(name)) continue;
                names.put(name, label2);
            }
            for (Map.Entry entry : names.entrySet()) {
                String stuff = "predefined/baseWidgets.html#";
                sb.append("<a href=\"" + stuff + (String)entry.getKey() + "\">" + (String)entry.getValue() + "</a>\n");
            }
            sb.append("<h3>Properties</h3>\n");
            sb.append("<table style=\"width: 100%;\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\">\n");
            sb.append("<tbody>\n");
            sb.append("  <tr style=\"background-color: silver;\">\n");
            sb.append("  <td valign=\"top\"><br><strong>Property Name</strong></td>\n");
            sb.append("  <td valign=\"top\"><br><strong>Type</strong></td>\n");
            sb.append("  <td valign=\"top\"><br><strong>Default Value</strong></td>\n");
            sb.append("  <td valign=\"top\"><br><strong>Description</strong></td>\n");
            sb.append("  </tr>\n");
            TreeMap<String, Resource> treeMap = new TreeMap<String, Resource>();
            for (Resource resource : graph.getObjects(type, L0.Asserts)) {
                Resource object = graph.getSingleObject(resource, L0.HasObject);
                if (graph.isInstanceOf(object, L0.SCLValue) || graph.isInstanceOf(object, L0.Function) || graph.isInstanceOf(object, L0.ExternalValue)) continue;
                Resource pred = graph.getSingleObject(resource, L0.HasPredicate);
                String pName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)pred);
                treeMap.put(pName, resource);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                String pDesc;
                Resource ass = (Resource)entry.getValue();
                Resource object = graph.getSingleObject(ass, L0.HasObject);
                Resource pred = graph.getSingleObject(ass, L0.HasPredicate);
                String pName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)pred);
                String valueType = (String)graph.getPossibleRelatedValue(pred, L0.RequiresValueType);
                Object jObject = graph.getValue(object);
                String objectName = jObject.toString();
                if (jObject.getClass().isArray()) {
                    Class<?> c1 = jObject.getClass().getComponentType();
                    boolean p1 = c1.isPrimitive();
                    if (!p1) {
                        objectName = Arrays.toString((Object[])jObject);
                    }
                    if (Boolean.TYPE.equals(c1)) {
                        objectName = Arrays.toString((boolean[])jObject);
                    } else if (Byte.TYPE.equals(c1)) {
                        objectName = Arrays.toString((byte[])jObject);
                    } else if (Integer.TYPE.equals(c1)) {
                        objectName = Arrays.toString((int[])jObject);
                    } else if (Long.TYPE.equals(c1)) {
                        objectName = Arrays.toString((long[])jObject);
                    } else if (Float.TYPE.equals(c1)) {
                        objectName = Arrays.toString((float[])jObject);
                    } else if (Double.TYPE.equals(c1)) {
                        objectName = Arrays.toString((double[])jObject);
                    }
                }
                if ((pDesc = (String)graph.getPossibleRelatedValue(pred, L0.HasDescription)) == null) {
                    pDesc = "";
                }
                sb.append("  <tr>\n");
                sb.append("  <td valign=\"top\">" + pName + "</td>\n");
                sb.append("  <td valign=\"top\">" + valueType + "</td>\n");
                sb.append("  <td valign=\"top\">" + objectName + "</td>\n");
                sb.append("  <td valign=\"top\">" + WikiParser.parseToHtml(pDesc, false) + "</td>\n");
                sb.append("  </tr>\n");
            }
            sb.append("  </tbody></table><br>\n");
        }
        sb.append("</body></html>\n");
        return sb.toString();
    }

    public static void clearHelpTocCache() {
        SimanticsTocProvider.clearTocCache();
    }

    public static void saveHelpFileContents(WriteGraph graph, Resource helpFile, String currentText) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        HelpResources HELP = HelpResources.getInstance((ReadGraph)graph);
        graph.claimLiteral(helpFile, HELP.HelpFile_contents, (Object)currentText, (Binding)Bindings.STRING);
    }

    public static String readHelpFileContents(ReadGraph graph, Resource helpFile) throws DatabaseException {
        HelpResources HELP = HelpResources.getInstance((ReadGraph)graph);
        String content = (String)graph.getPossibleRelatedValue2(helpFile, HELP.HelpFile_contents, (Binding)Bindings.STRING);
        return content != null ? content : "";
    }

    public static String markdownToHtml(ReadGraph graph, Resource tutorialFile) throws DatabaseException {
        HelpResources HELP = HelpResources.getInstance((ReadGraph)graph);
        String markdown = (String)graph.getRelatedValue2(tutorialFile, HELP.HelpFile_contents, (Binding)Bindings.STRING);
        MarkdownPage page = new MarkdownPage(markdown);
        return page.html();
    }

    public static URL getHelpBrowserUrl() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        URL url = helpSystem.resolve("", false);
        return url;
    }

    private static class WikiParser {
        private static MarkupParser markupParser = new MarkupParser((MarkupLanguage)new MediaWikiLanguage());

        private WikiParser() {
        }

        public static String parseToHtml(String wiki, boolean asDocument) {
            StringWriter writer = new StringWriter();
            HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer);
            markupParser.setBuilder((DocumentBuilder)builder);
            markupParser.parse(wiki, asDocument);
            return writer.toString();
        }
    }
}

