/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.LiteralFileUtil;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;

public class GraphFileUtil {
    public static boolean USE_RANDOM_ACCESS_BINARY = true;

    public static File toTempFile(final Resource res) throws DatabaseException {
        return (File)Simantics.getSession().syncRequest((Read)new Read<File>(){

            public File perform(ReadGraph graph) throws DatabaseException {
                return GraphFileUtil.toTempFile(graph, res);
            }
        });
    }

    public static File toTempFile(ReadGraph graph, Resource res) throws DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        String filename = (String)graph.getPossibleRelatedValue(res, gf.HasResourceName);
        if (filename == null) {
            filename = (String)graph.getRelatedValue(res, Layer0.getInstance((ReadGraph)graph).HasName);
        }
        int index = filename.lastIndexOf(".");
        String name = "";
        String ext = "";
        if (index > 0) {
            name = filename.substring(0, index);
            ext = filename.substring(index + 1);
        } else {
            name = filename;
        }
        if (name.length() < 3) {
            int i = name.length();
            while (i < 3) {
                name = String.valueOf(name) + "_";
                ++i;
            }
        }
        try {
            File file = File.createTempFile(name, "." + ext);
            GraphFileUtil.writeDataToFile(graph, res, file);
            return file;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void writeDataToFile(final Resource res, final File file) throws DatabaseException {
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    GraphFileUtil.writeDataToFile(graph, res, file);
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    public static void writeDataToFile(ReadGraph graph, Resource res, File file) throws DatabaseException, IOException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        if (USE_RANDOM_ACCESS_BINARY) {
            Resource filedata = graph.getSingleObject(res, gf.HasFiledata);
            LiteralFileUtil.copyRandomAccessBinaryToFile((ReadGraph)graph, (Resource)filedata, (File)file);
        } else {
            byte[] data = (byte[])graph.getRelatedValue(res, gf.HasFiledata);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.flush();
            fos.close();
        }
        Long lastModified = (Long)graph.getPossibleRelatedValue(res, gf.LastModified);
        if (lastModified != null) {
            file.setLastModified(lastModified);
        }
    }

    public static void toGraph(final String filename, final Resource graphFile) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                try {
                    GraphFileUtil.toGraph(graph, filename, graphFile);
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    public static void toGraph(WriteGraph graph, String filename, Resource graphFile) throws DatabaseException, IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException("File " + filename + " not found.");
        }
        GraphFileUtil.toGraph(graph, file, graphFile);
    }

    public static void toGraph(WriteGraph graph, File file, Resource graphFile) throws DatabaseException, IOException {
        GraphFileUtil.writeDataToGraph(graph, file, graphFile);
        String name = file.getName();
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(graphFile, gf.HasResourceName, (Object)name);
    }

    public static void writeDataToGraph(WriteGraph graph, File file, Resource graphFile) throws IOException, DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        if (USE_RANDOM_ACCESS_BINARY) {
            Resource fileData = graph.getPossibleObject(graphFile, gf.HasFiledata);
            RandomAccessBinary rab = null;
            if (fileData == null) {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
                fileData = graph.newResource(cs.createCluster());
                graph.claim(fileData, l0.InstanceOf, l0.ByteArray);
                graph.claim(graphFile, gf.HasFiledata, fileData);
                rab = graph.createRandomAccessBinary(fileData, (Datatype)Bindings.BYTE_ARRAY.type(), null);
            } else {
                rab = graph.getRandomAccessBinary(fileData);
            }
            LiteralFileUtil.copyRandomAccessBinaryFromFile((File)file, (RandomAccessBinary)rab);
        } else {
            FileInputStream stream = new FileInputStream(file);
            FileChannel chan = stream.getChannel();
            long lsize = chan.size();
            if (lsize > Integer.MAX_VALUE) {
                throw new IOException("File is too big");
            }
            int size = (int)lsize;
            byte[] array = new byte[size];
            ByteBuffer buf = ByteBuffer.wrap(array);
            while (size > 0) {
                size -= chan.read(buf);
            }
            graph.claimLiteral(graphFile, gf.HasFiledata, (Object)array);
            chan.close();
            stream.close();
        }
        graph.claimLiteral(graphFile, gf.LastModified, (Object)file.lastModified());
    }

    public static void writeDataToGraph(WriteGraph graph, byte[] data, Resource graphFile) throws IOException, DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        if (USE_RANDOM_ACCESS_BINARY) {
            Resource fileData = graph.getPossibleObject(graphFile, gf.HasFiledata);
            if (fileData == null) {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
                fileData = graph.newResource(cs.createCluster());
                graph.claim(fileData, l0.InstanceOf, l0.ByteArray);
                graph.claim(graphFile, gf.HasFiledata, fileData);
                graph.createRandomAccessBinary(fileData, (Datatype)Bindings.BYTE_ARRAY.type(), (Object)data);
            } else {
                ByteArrayInputStream input = new ByteArrayInputStream(data);
                LiteralFileUtil.copyStreamToRandomAccessBinary((WriteGraph)graph, (InputStream)input, (Resource)fileData);
            }
        } else {
            graph.claimLiteral(graphFile, gf.HasFiledata, (Object)data);
        }
        graph.claimLiteral(graphFile, gf.LastModified, (Object)System.currentTimeMillis());
    }

    public static void writeDataToGraph(final File file, final Resource graphFile) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                try {
                    GraphFileUtil.writeDataToGraph(graph, file, graphFile);
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    public static void syncFolderToGraph(WriteGraph g, File folder, Resource folderRes) throws Exception {
        File[] subFiles = folder.listFiles();
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)g);
        Collection subFileResources = g.getObjects(folderRes, gf.HasFile);
        Collection subFolderResources = g.getObjects(folderRes, gf.HasFolder);
        HashMap<Resource, File> matching = new HashMap<Resource, File>();
        File[] fileArray = subFiles;
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            if (f.isDirectory()) {
                Resource matchingFolder = GraphFileUtil.findWithName((ReadGraph)g, subFolderResources, name);
                if (matchingFolder != null) {
                    if (matching.containsKey(matchingFolder)) {
                        throw new Exception("Matching folder already in use" + f.getAbsolutePath() + " " + matchingFolder);
                    }
                    matching.put(matchingFolder, f);
                    GraphFileUtil.syncFolderToGraph(g, f, matchingFolder);
                } else {
                    matchingFolder = g.newResource();
                    g.claim(matchingFolder, l0.InstanceOf, gf.Folder);
                    g.claimLiteral(matchingFolder, gf.HasResourceName, (Object)name);
                    g.claimLiteral(matchingFolder, l0.HasName, (Object)name);
                    g.claim(folderRes, gf.HasFolder, matchingFolder);
                    matching.put(matchingFolder, f);
                    GraphFileUtil.syncFolderToGraph(g, f, matchingFolder);
                }
            } else {
                Resource fileRes = GraphFileUtil.findWithName((ReadGraph)g, subFileResources, name);
                if (fileRes != null) {
                    if (matching.containsKey(fileRes)) {
                        throw new Exception("Matching file already in use" + f.getAbsolutePath() + " " + fileRes);
                    }
                    matching.put(fileRes, f);
                    GraphFileUtil.toGraph(g, f, fileRes);
                } else {
                    fileRes = g.newResource();
                    g.claim(fileRes, l0.InstanceOf, gf.File);
                    g.claimLiteral(fileRes, gf.HasResourceName, (Object)name);
                    g.claimLiteral(fileRes, l0.HasName, (Object)name);
                    g.claim(folderRes, gf.HasFile, fileRes);
                    matching.put(fileRes, f);
                    GraphFileUtil.toGraph(g, f, fileRes);
                }
            }
            ++n2;
        }
        for (Resource subFolder : subFolderResources) {
            if (matching.containsKey(subFolder)) continue;
            g.deny(subFolder);
        }
        for (Resource subFolder : subFileResources) {
            if (matching.containsKey(subFolder)) continue;
            g.deny(subFolder);
        }
    }

    public static void writeFolderToDisk(ReadGraph g, Resource folderRes, File folder) throws DatabaseException, IOException {
        String name;
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)g);
        for (Resource subFolder : g.getObjects(folderRes, gf.HasFolder)) {
            name = (String)g.getRelatedValue(subFolder, gf.HasResourceName);
            if (name.length() == 0) {
                throw new DatabaseException("Empty folder name for " + subFolder);
            }
            File newFolder = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            if (!newFolder.mkdir()) {
                throw new DatabaseException("Could not create folder " + name + " for resource " + subFolder);
            }
            GraphFileUtil.writeFolderToDisk(g, subFolder, newFolder);
        }
        for (Resource fileRes : g.getObjects(folderRes, gf.HasFile)) {
            name = (String)g.getRelatedValue(fileRes, gf.HasResourceName);
            File file = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            GraphFileUtil.writeDataToFile(g, fileRes, file);
        }
    }

    public static void syncFolderToGraph(WriteGraph g, File folder, Resource folderRes, ToGraphHelper helper) throws Exception {
        File[] subFiles = folder.listFiles();
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)g);
        Collection subFileResources = g.getObjects(folderRes, gf.HasFile);
        Collection subFolderResources = g.getObjects(folderRes, gf.HasFolder);
        HashMap<Resource, File> matching = new HashMap<Resource, File>();
        File[] fileArray = subFiles;
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            if (f.isDirectory()) {
                Resource matchingFolder = helper.findFolder((ReadGraph)g, subFolderResources, name);
                if (matchingFolder != null) {
                    if (matching.containsKey(matchingFolder)) {
                        throw new Exception("Matching folder already in use" + f.getAbsolutePath() + " " + matchingFolder);
                    }
                    matching.put(matchingFolder, f);
                    GraphFileUtil.syncFolderToGraph(g, f, matchingFolder, helper);
                } else {
                    matchingFolder = helper.createFolder(g, name);
                    g.claim(folderRes, gf.HasFolder, matchingFolder);
                    matching.put(matchingFolder, f);
                    GraphFileUtil.syncFolderToGraph(g, f, matchingFolder, helper);
                }
            } else {
                Resource fileRes = helper.findFile((ReadGraph)g, subFileResources, name);
                if (fileRes != null) {
                    if (matching.containsKey(fileRes)) {
                        throw new Exception("Matching file already in use" + f.getAbsolutePath() + " " + fileRes);
                    }
                    matching.put(fileRes, f);
                    GraphFileUtil.toGraph(g, f, fileRes);
                } else {
                    fileRes = helper.createFile(g, name);
                    g.claim(folderRes, gf.HasFile, fileRes);
                    matching.put(fileRes, f);
                    GraphFileUtil.toGraph(g, f, fileRes);
                }
            }
            ++n2;
        }
        for (Resource subFolder : subFolderResources) {
            if (matching.containsKey(subFolder)) continue;
            g.deny(subFolder);
        }
        for (Resource subFolder : subFileResources) {
            if (matching.containsKey(subFolder)) continue;
            g.deny(subFolder);
        }
    }

    public static void writeFolderToDisk(ReadGraph g, Resource folderRes, File folder, ToDiskHelper helper) throws DatabaseException, IOException {
        String name;
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)g);
        for (Resource subFolder : g.getObjects(folderRes, gf.HasFolder)) {
            name = helper.getName(g, subFolder);
            if (name.length() == 0) {
                throw new DatabaseException("Empty folder name for " + subFolder);
            }
            File newFolder = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            if (!newFolder.mkdir()) {
                throw new DatabaseException("Could not create folder " + name + " for resource " + subFolder);
            }
            GraphFileUtil.writeFolderToDisk(g, subFolder, newFolder, helper);
        }
        for (Resource fileRes : g.getObjects(folderRes, gf.HasFile)) {
            name = helper.getName(g, fileRes);
            File file = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            GraphFileUtil.writeDataToFile(g, fileRes, file);
        }
    }

    public static void syncFolderToDisk(ReadGraph g, Resource folderRes, File folder, ToDiskHelper2 helper) throws Exception {
        File[] subFiles = folder.listFiles();
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)g);
        Collection subFileResources = g.getObjects(folderRes, gf.HasFile);
        Collection subFolderResources = g.getObjects(folderRes, gf.HasFolder);
        HashMap<Resource, File> matching = new HashMap<Resource, File>();
        File[] fileArray = subFiles;
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            if (f.isDirectory()) {
                Resource matchingFolder = helper.findFolder(g, subFolderResources, name);
                if (matchingFolder != null) {
                    if (matching.containsKey(matchingFolder)) {
                        throw new Exception("Matching folder already in use" + f.getAbsolutePath() + " " + matchingFolder);
                    }
                    matching.put(matchingFolder, f);
                    GraphFileUtil.syncFolderToDisk(g, matchingFolder, f, helper);
                } else {
                    GraphFileUtil.deleteDirectoryStructure(f);
                }
            } else {
                Resource fileRes = helper.findFile(g, subFileResources, name);
                if (fileRes != null) {
                    if (matching.containsKey(fileRes)) {
                        throw new Exception("Matching file already in use" + f.getAbsolutePath() + " " + fileRes);
                    }
                    matching.put(fileRes, f);
                    GraphFileUtil.writeDataToFile(g, fileRes, f);
                } else if (!f.delete()) {
                    throw new Exception("Cannot delete file " + f.getAbsolutePath());
                }
            }
            ++n2;
        }
        for (Resource subFolder : subFolderResources) {
            if (matching.containsKey(subFolder)) continue;
            String name = helper.getName(g, subFolder);
            if (name.length() == 0) {
                throw new DatabaseException("Empty folder name for " + subFolder);
            }
            File newFolder = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            if (!newFolder.mkdir()) {
                throw new DatabaseException("Could not create folder " + name + " for resource " + subFolder);
            }
            GraphFileUtil.writeFolderToDisk(g, subFolder, newFolder, helper);
        }
        for (Resource fileRes : subFileResources) {
            if (matching.containsKey(fileRes)) continue;
            String name = helper.getName(g, fileRes);
            File file = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            GraphFileUtil.writeDataToFile(g, fileRes, file);
        }
    }

    public static Resource findWithName(ReadGraph g, Collection<Resource> resources, String name) throws ServiceException, NoSingleResultException, DoesNotContainValueException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)g);
        for (Resource r : resources) {
            if (!name.equals(g.getRelatedValue(r, gf.HasResourceName))) continue;
            return r;
        }
        return null;
    }

    public static void deleteDirectoryStructure(File dir) throws Exception {
        GraphFileUtil.deleteDirectoryStructure(dir, true);
    }

    public static void clearDirectoryStructure(File dir) throws Exception {
        GraphFileUtil.deleteDirectoryStructure(dir, false);
    }

    private static void deleteDirectoryStructure(File dir, boolean deleteDir) throws Exception {
        File[] subFiles;
        File[] fileArray = subFiles = dir.listFiles();
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                GraphFileUtil.deleteDirectoryStructure(f, true);
            } else if (!f.delete()) {
                throw new Exception("Cannot delete file " + f.getAbsolutePath());
            }
            ++n2;
        }
        if (deleteDir && !dir.delete()) {
            throw new Exception("Cannot delete folder " + dir.getAbsolutePath());
        }
    }

    public static Resource createFileReference(final Resource parent, final Path path) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
                Resource file = graph.newResource();
                graph.claim(file, L0.PartOf, parent);
                graph.claim(file, L0.InstanceOf, GF.File);
                String name = path.getFileName().toString();
                graph.claimLiteral(file, L0.HasName, (Object)name, (Binding)Bindings.STRING);
                graph.claimLiteral(file, GF.SystemPath, (Object)path.toAbsolutePath().toString(), (Binding)Bindings.STRING);
                return file;
            }
        });
    }

    public static void writeDataToGraphSCLhack(WriteGraph graph, File file, Resource graphFile) throws IOException, DatabaseException {
        GraphFileUtil.writeDataToGraph(graph, file, graphFile);
    }

    public static File toTempFileSCLhack(ReadGraph graph, Resource res) throws DatabaseException {
        return GraphFileUtil.toTempFile(graph, res);
    }

    public static void writeDataToFileSCLhack(ReadGraph graph, Resource res, File file) throws DatabaseException, IOException {
        GraphFileUtil.writeDataToFile(graph, res, file);
    }

    public static void toGraphSCLhack(WriteGraph graph, String filename, Resource graphFile) throws DatabaseException, IOException {
        GraphFileUtil.toGraph(graph, filename, graphFile);
    }

    public static byte[] getData(ReadGraph graph, Resource graphFile) throws DatabaseException {
        GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
        Resource fileData = graph.getSingleObject(graphFile, GF.HasFiledata);
        TransferableGraphSupport tgs = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
        InputStream input = tgs.getValueStream(graph, fileData);
        DataInputStream di = new DataInputStream(input);
        try {
            int length = di.readInt();
            byte[] content = new byte[length];
            di.read(content);
            return content;
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static String getDataAsString(ReadGraph graph, Resource graphFile) throws DatabaseException {
        byte[] content = GraphFileUtil.getData(graph, graphFile);
        String s = new String(content);
        return s;
    }

    public static interface ToDiskHelper {
        public String getName(ReadGraph var1, Resource var2) throws DatabaseException;
    }

    public static interface ToDiskHelper2
    extends ToDiskHelper {
        public Resource findFolder(ReadGraph var1, Collection<Resource> var2, String var3) throws DatabaseException;

        public Resource findFile(ReadGraph var1, Collection<Resource> var2, String var3) throws DatabaseException;
    }

    public static interface ToGraphHelper {
        public Resource findFolder(ReadGraph var1, Collection<Resource> var2, String var3) throws DatabaseException;

        public Resource createFolder(WriteGraph var1, String var2) throws DatabaseException;

        public Resource findFile(ReadGraph var1, Collection<Resource> var2, String var3) throws DatabaseException;

        public Resource createFile(WriteGraph var1, String var2) throws DatabaseException;
    }
}

