/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphfile.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;

public class SystemResourcePasteHandler  extends PasteHandlerAdapter  

{
	private Resource resource;

    public SystemResourcePasteHandler(Resource resource) {
        this.resource = resource;
    }

    public static void defaultExecute(TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        TransferableGraphs.importGraph1(Simantics.getSession(), tg, advisor);
    }

    public static void defaultExecute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        TransferableGraphs.importGraph1(graph, tg, advisor);
    }

    public void execute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
    	defaultExecute(graph, tg, resource, advisor);
    }

    /**
     * Override this in your inherited class if post processing is done.
     */
    public void onPasteBegin(WriteGraph graph) throws DatabaseException {
    }

    /**
     * Override this in your inherited class if post processing is done
     * advisor.getTarget() returns an object under which data is copied
     * advisor.getRoot() returns the object which have been pasted.
     * @param representations TODO
     */
    public void onPaste(WriteGraph graph, SystemResourcePasteImportAdvisor advisor, Set<Representation> representations) throws DatabaseException {
    	advisor.attachRoot(graph);
    }

    /**
     * Override this in your inherited class if post processing is done.
     */
    public void onPasteEnd(WriteGraph graph) throws DatabaseException{
    }

    public Collection<Resource> pasteObject(WriteGraph graph, Set<Representation> object) throws DatabaseException {
    	Collection<Resource> result = new ArrayList<Resource>();
        TransferableGraph1 tg = ClipboardUtils.accept(graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
        if (tg != null) {
           SystemResourcePasteImportAdvisor advisor = new SystemResourcePasteImportAdvisor(graph, resource); 
            execute(graph, tg, resource, advisor);
            result.add(advisor.getRoot());
            try {
                onPaste(graph, advisor, object);
            } catch (Throwable e) {
            }
        }
        return result;
    }

    @Override
    public Collection<Resource> pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
    	
    	Collection<Resource> result = new ArrayList<Resource>();
    	
        try {
            onPasteBegin(graph);
        } catch (Throwable e) {
        }

        final Set<Resource> cuts = new HashSet<Resource>();
        for(Set<Representation> object : clipboard.getContents()) {
            result.addAll(pasteObject(graph, object));
            Collection<Resource> cut = ClipboardUtils.accept(object, SimanticsKeys.KEY_CUT_RESOURCES);
            if (cut != null)
                cuts.addAll(cut);
        }

        try {
            onPasteEnd(graph);
        } catch (Throwable e) {
        }

        if(!cuts.isEmpty()) {
        	for (Resource cut : cuts)
        		RemoverUtil.remove(graph, cut);
        }
        
        return result;
        
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Class adapter) {
        if(Resource.class == adapter) return resource;
        return null;
    }

	

}
