/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.query;

import org.simantics.databoard.util.URIStringUtils;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.PathRoot;
import org.simantics.graph.query.Paths;

public class UriUtils {
    public static Path uriToPath(String uri) {
        Path cur;
        String[] segments;
        if (uri.startsWith("http:/")) {
            if (uri.length() == 6) {
                return Paths.Root;
            }
            segments = uri.substring(7).split("/");
            cur = Paths.Root;
        } else {
            int p = uri.indexOf(47);
            if (p == -1) {
                return new PathRoot(uri);
            }
            segments = uri.substring(p + 1).split("/");
            cur = new PathRoot(uri.substring(0, p));
        }
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            cur = new PathChild(segment, cur);
            ++n2;
        }
        return cur;
    }

    public static Path uriToPathUnescaped(String uri) {
        Path cur;
        String[] segments;
        if (uri.startsWith("http:/")) {
            if (uri.length() == 6) {
                return Paths.Root;
            }
            segments = uri.substring(7).split("/");
            cur = Paths.Root;
        } else {
            int p = uri.indexOf(47);
            if (p == -1) {
                return new PathRoot(URIStringUtils.unescape((String)uri));
            }
            segments = uri.substring(p + 1).split("/");
            cur = new PathRoot(URIStringUtils.unescape((String)uri.substring(0, p)));
        }
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            cur = new PathChild(URIStringUtils.unescape((String)segment), cur);
            ++n2;
        }
        return cur;
    }
}

