package org.simantics.graph.matching;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntDoubleProcedure;
import gnu.trove.procedure.TIntObjectProcedure;

public enum VotingMatchingStrategy implements GraphMatchingStrategy {
	INSTANCE;

	public static void vote(
			final TIntDoubleHashMap[] voting, 
			int[] aToB,
			int[] bToA,
			Stat[] aStat,
			Stat[] bStat,
			final String[] bNames) {
		final TIntObjectHashMap<TIntArrayList> aMap =
			new TIntObjectHashMap<TIntArrayList>();		
		for(Stat stat : aStat) {
			int mp = aToB[stat.p];
			if(mp >= 0 && aToB[stat.o] < 0) {
				TIntArrayList l = aMap.get(mp);
				if(l == null) {
					l = new TIntArrayList(2);
					aMap.put(mp, l);
				}
				l.add(stat.o);
 			}
		}
		TIntObjectHashMap<TIntArrayList> bMap =
			new TIntObjectHashMap<TIntArrayList>();
		for(Stat stat : bStat) {
			int p = stat.p;
			int o = stat.o;
			if(bToA[p] >= 0 && bToA[o] < 0) {
				TIntArrayList l = bMap.get(p);
				if(l == null) {
					l = new TIntArrayList(2);
					bMap.put(p, l);
				}
				l.add(o);
 			}
		}
		/*System.out.println("---------------------------------------");
		aMap.forEachEntry(new TIntObjectProcedure<TIntArrayList>() {
			@Override
			public boolean execute(int a, TIntArrayList b) {
				System.out.println("a " + bNames[a] + " -> " + b);
				return true;
			}
		});
		bMap.forEachEntry(new TIntObjectProcedure<TIntArrayList>() {
			@Override
			public boolean execute(int a, TIntArrayList b) {
				System.out.println("b " + bNames[a] + " -> " + b);
				return true;
			}
		});*/
		bMap.forEachEntry(new TIntObjectProcedure<TIntArrayList>() {			
			@Override
			public boolean execute(int p, TIntArrayList bos) {
				TIntArrayList aos = aMap.get(p);
				if(aos != null && aos.size() <= 4 && bos.size() <= 4) {
					final double weight = 1.0 / bos.size();
					for(int i=0;i<aos.size();++i)
						for(int j=0;j<bos.size();++j)
							voting[aos.get(i)].adjustOrPutValue(bos.get(j), weight, weight);
				}
				return true;
			}
		});
	}
	
	@Override
	public void applyTo(GraphMatching matching) {
		int[] aToB = matching.aToB;
		final int[] bToA = matching.bToA;
		int resourceCount = aToB.length;
		Stat[][] aStatements = matching.aGraph.statements;
		Stat[][] bStatements = matching.bGraph.statements;
		TIntIntHashMap aInv = matching.aGraph.inverses;
		TIntIntHashMap bInv = matching.bGraph.inverses;
		
		TIntDoubleHashMap[] voting = new TIntDoubleHashMap[resourceCount];
		for(int i=0;i<resourceCount;++i)
			if(aToB[i] < 0)
				voting[i] = new TIntDoubleHashMap();
		for(int s=0;s<resourceCount;++s) {
			int ms = aToB[s];
			if(ms >= 0 && ms < bStatements.length)
				vote(voting, aToB, bToA, aStatements[s], bStatements[ms], matching.bGraph.names);
		}
		
		for(int a=0;a<resourceCount;++a) {
			TIntDoubleHashMap votes = voting[a];
			if(votes != null && !votes.isEmpty()) {
				final int[] best = new int[] { -1 };
				votes.forEachEntry(new TIntDoubleProcedure() {
					double bestWeight = 0.9;
					@Override
					public boolean execute(int b, double weight) {
						if(weight > bestWeight && bToA[b] < 0) {
							bestWeight = weight;
							best[0] = b;
						}
						return true;
					}
				});
				if(best[0] >= 0) {
					int b = best[0];
					matching.map(a, b);
					if(aInv.contains(a) && bInv.contains(b) && aInv.get(a) != a)
						matching.map(aInv.get(a), bInv.get(b));
				}
			}
		}
	}
	
}
