/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.translation;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.antlr.runtime.tree.Tree;
import org.simantics.graph.compiler.SourceInfo;
import org.simantics.graph.compiler.internal.ltk.ISource;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.ltk.antlr.ANTLRUtils;
import org.simantics.graph.compiler.internal.parsing.GraphParser;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.store.PreValueStore;
import org.simantics.graph.compiler.internal.templates.TemplateDefinition;
import org.simantics.graph.compiler.internal.templates.TemplateDefinitionStore;
import org.simantics.graph.compiler.internal.templates.TemplateInstanceStore;
import org.simantics.graph.compiler.internal.translation.ChildGraphTranslator;
import org.simantics.graph.compiler.internal.translation.DataTypeTranslator;
import org.simantics.graph.compiler.internal.values.TreeValue;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.store.GraphStore;

public class GraphTranslator
extends GraphStore {
    ISource source;
    Collection<Problem> problems;
    TObjectIntHashMap<String> variables = new TObjectIntHashMap();
    ArrayList<SourceInfo.DefinitionPosition> definitionPositions = new ArrayList();
    TIntHashSet definedResources = new TIntHashSet();
    LocationStore locations;
    TemplateInstanceStore templateInstances;
    TemplateDefinitionStore templateDefinitions;
    PreValueStore preValues;
    Paths paths;
    int layer0;
    int equalsId = 0;
    int inheritsId = 0;
    int subrelationOfId = 0;
    int instanceOfId = 0;
    int hasDomainId = 0;
    int hasRangeId = 0;
    int domainOfId = 0;
    int requiresValueTypeId = 0;
    int DatatypeId = 0;

    public GraphTranslator(Paths paths, Collection<Problem> problems, GraphStore store) {
        super(store);
        this.problems = problems;
        this.paths = paths;
        this.locations = (LocationStore)this.getStore(LocationStore.class);
        if (this.locations == null) {
            this.locations = new LocationStore();
            this.addStore(LocationStore.class, this.locations);
        }
        this.templateInstances = (TemplateInstanceStore)this.getStore(TemplateInstanceStore.class);
        if (this.templateInstances == null) {
            this.templateInstances = new TemplateInstanceStore();
            this.addStore(TemplateInstanceStore.class, this.templateInstances);
        }
        this.templateDefinitions = (TemplateDefinitionStore)this.getStore(TemplateDefinitionStore.class);
        if (this.templateDefinitions == null) {
            this.templateDefinitions = new TemplateDefinitionStore();
            this.addStore(TemplateDefinitionStore.class, this.templateDefinitions);
        }
        this.preValues = (PreValueStore)this.getStore(PreValueStore.class);
        if (this.preValues == null) {
            this.preValues = new PreValueStore();
            this.addStore(PreValueStore.class, this.preValues);
        }
        this.layer0 = this.identities.createPathToId(paths.Layer0);
    }

    public void setSource(ISource source) {
        this.source = source;
    }

    public void translateGraph(Tree tree) {
        int count = tree.getChildCount();
        int i = 0;
        while (i < count) {
            this.translateResourceDefinition(tree.getChild(i));
            ++i;
        }
    }

    protected void locate(int resource, Tree tree) {
        this.locations.add(resource, ANTLRUtils.location(this.source, tree));
    }

    public int translateResourceDefinition(Tree tree) {
        Tree subjectTree = tree.getChild(0);
        int subject = this.translateResource(subjectTree);
        int count = tree.getChildCount();
        int i = 1;
        while (i < count) {
            Tree child = tree.getChild(i);
            switch (child.getType()) {
                case 34: {
                    this.translateProperty(subject, subjectTree, child);
                    break;
                }
                case 48: {
                    this.translateTemplateInstance(subject, child);
                    break;
                }
                case 47: {
                    this.translateTemplateDefinition(subject, child);
                }
            }
            ++i;
        }
        return subject;
    }

    private void translateProperty(int subject, Tree subjectTree, Tree tree) {
        int predicate = this.translateResource(tree.getChild(0));
        if ((predicate == this.instanceOfId || predicate == this.inheritsId || predicate == this.subrelationOfId) && this.definedResources.add(subject)) {
            this.definitionPositions.add(new SourceInfo.DefinitionPosition(subject, ANTLRUtils.getStartLine(subjectTree) + this.source.startLine(), ANTLRUtils.getStartIndex(subjectTree) + this.source.startPos(), ANTLRUtils.getStopIndex(subjectTree) + this.source.startPos()));
        }
        int count = tree.getChildCount();
        int i = 1;
        while (i < count) {
            int object = this.translateResourceDefinition(tree.getChild(i));
            this.statements.add(subject, predicate, object);
            ++i;
        }
    }

    private void translateTemplateInstance(int subject, Tree tree) {
        int parameterCount = tree.getChildCount();
        int[] templateInstance = new int[parameterCount + 1];
        templateInstance[0] = this.translateResource(tree.getChild(0));
        templateInstance[1] = subject;
        int i = 1;
        while (i < parameterCount) {
            Tree child = tree.getChild(i);
            templateInstance[i + 1] = child.getType() == 42 ? this.translateResourceDefinition(child) : this.translateResource(child);
            ++i;
        }
        this.templateInstances.add(templateInstance);
    }

    private void translateTemplateDefinition(int subject, Tree tree) {
        ArrayList<String> parameters = new ArrayList<String>();
        int i = 0;
        while (i < tree.getChildCount() && tree.getChild(i).getType() == 62) {
            parameters.add(tree.getChild(i).getChild(0).getText());
            ++i;
        }
        GraphStore store = new GraphStore();
        ChildGraphTranslator translator = new ChildGraphTranslator(this, store);
        translator.setSource(this.source);
        while (i < tree.getChildCount()) {
            translator.translateResourceDefinition(tree.getChild(i));
            ++i;
        }
        this.templateDefinitions.add(subject, new TemplateDefinition(parameters.toArray(new String[parameters.size()]), translator.correspondences.toArray(), store));
    }

    public static void printTree(Tree tree) {
        GraphTranslator.printTree(0, tree);
    }

    private int translateResource(Tree tree) {
        switch (tree.getType()) {
            case 12: {
                int id = this.identities.newResource();
                this.preValues.setValue(id, new TreeValue(this.source, tree.getChild(0)));
                this.locate(id, tree.getChild(0));
                return id;
            }
            case 11: {
                int DataType = this.identities.newResource();
                this.values.setValue(DataType, new DataTypeTranslator(this.source, this.problems).translate(tree.getChild(0)));
                if (this.instanceOfId == 0) {
                    this.instanceOfId = this.identities.getChild(this.layer0, "InstanceOf");
                }
                if (this.DatatypeId == 0) {
                    this.DatatypeId = this.identities.getChild(this.layer0, "DataType");
                }
                this.statements.add(DataType, this.instanceOfId, this.DatatypeId);
                this.locate(DataType, tree.getChild(0));
                return DataType;
            }
            case 7: {
                int id = this.identities.newResource();
                this.locate(id, tree);
                return id;
            }
            case 22: {
                return this.getVariable(tree, tree.getText());
            }
            case 62: {
                int id = this.identities.getRoot(tree.getChild(0).getText());
                this.locate(id, tree);
                return id;
            }
            case 59: {
                String uri = tree.getText();
                uri = uri.substring(1, uri.length() - 1);
                int id = this.identities.createPathToId(UriUtils.uriToPath((String)uri));
                this.locate(id, tree);
                return id;
            }
            case 40: {
                int parent = this.translateResource(tree.getChild(0));
                Tree nameNode = tree.getChild(1);
                String name = nameNode.getText();
                if (nameNode.getType() == 44) {
                    name = name.substring(1, name.length() - 1);
                }
                int id = this.identities.getChild(parent, name);
                this.locate(id, tree);
                return id;
            }
            case 13: {
                if (this.equalsId == 0) {
                    this.equalsId = this.identities.getChild(this.layer0, "Equals");
                }
                return this.equalsId;
            }
            case 24: {
                if (this.inheritsId == 0) {
                    this.inheritsId = this.identities.getChild(this.layer0, "Inherits");
                }
                return this.inheritsId;
            }
            case 45: {
                if (this.subrelationOfId == 0) {
                    this.subrelationOfId = this.identities.getChild(this.layer0, "SubrelationOf");
                }
                return this.subrelationOfId;
            }
            case 25: {
                if (this.instanceOfId == 0) {
                    this.instanceOfId = this.identities.getChild(this.layer0, "InstanceOf");
                }
                return this.instanceOfId;
            }
            case 19: {
                if (this.hasDomainId == 0) {
                    this.hasDomainId = this.identities.getChild(this.layer0, "HasDomain");
                }
                return this.hasDomainId;
            }
            case 20: {
                if (this.hasRangeId == 0) {
                    this.hasRangeId = this.identities.getChild(this.layer0, "HasRange");
                }
                return this.hasRangeId;
            }
            case 10: {
                if (this.domainOfId == 0) {
                    this.domainOfId = this.identities.getChild(this.layer0, "DomainOf");
                }
                return this.domainOfId;
            }
            case 41: {
                if (this.requiresValueTypeId == 0) {
                    this.requiresValueTypeId = this.identities.getChild(this.layer0, "RequiresValueType");
                }
                return this.requiresValueTypeId;
            }
        }
        System.out.println("-- " + GraphParser.tokenNames[tree.getType()]);
        GraphTranslator.printTree(tree);
        return 0;
    }

    public int getVariable(Tree place, String text) {
        if (this.variables.containsKey((Object)text)) {
            return this.variables.get((Object)text);
        }
        int id = this.identities.newResource();
        this.variables.put((Object)text, id);
        this.locate(id, place);
        return id;
    }

    public TObjectIntHashMap<String> getVariables() {
        return this.variables;
    }

    public ArrayList<SourceInfo.DefinitionPosition> getDefinitionPositions() {
        return this.definitionPositions;
    }

    public static void printTree(int indent, Tree tree) {
        int i = 0;
        while (i < indent) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(tree.getText());
        i = 0;
        while (i < tree.getChildCount()) {
            GraphTranslator.printTree(indent + 1, tree.getChild(i));
            ++i;
        }
    }
}

