/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.templates;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.procedures.Compactify;
import org.simantics.graph.compiler.internal.procedures.ConvertPreValues;
import org.simantics.graph.compiler.internal.procedures.DefaultValueTyping;
import org.simantics.graph.compiler.internal.procedures.MergeEqualResources;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;

public class TemplateDefinition {
    String[] parameters;
    int[] correspondence;
    GraphStore template;

    public TemplateDefinition(String[] parameters, int[] correspondence, GraphStore template) {
        this.parameters = parameters;
        this.correspondence = correspondence;
        this.template = template;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public GraphStore getTemplate() {
        return this.template;
    }

    public void map(TIntIntHashMap map) {
        int i = 0;
        while (i < this.correspondence.length) {
            if (map.containsKey(this.correspondence[i])) {
                this.correspondence[i] = map.get(this.correspondence[i]);
            }
            i += 2;
        }
    }

    public TransferableGraph1 convert(CompositeGraph graph, GraphStore parent, Collection<Problem> problems) {
        LocationStore locations = (LocationStore)this.template.getStore(LocationStore.class);
        int i = 0;
        while (i < this.correspondence.length) {
            int parentId = this.correspondence[i];
            int childId = this.correspondence[i + 1];
            Path path = parent.identities.idToPath(parentId);
            if (path == null) {
                problems.add(new Problem(locations.getLocation(childId), "Template can refer only to resources that have URIs."));
            } else {
                this.template.identities.definePath(path, childId);
            }
            i += 2;
        }
        new MergeEqualResources(graph.getPaths(), this.template).run();
        new Compactify(this.template).run();
        new DefaultValueTyping(graph.getPaths(), this.template).run();
        graph.addFragment(this.template);
        new ConvertPreValues((IGraph)graph, this.template, problems).run();
        TransferableGraph1 transferableGraph = TransferableGraphConversion.convert((GraphStore)this.template);
        graph.undoAddFragment();
        return transferableGraph;
    }
}

