/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.unparsing.DataTypePrinter;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.LocalStatement;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IStatementProcedure;

public class GraphUnparser {
    IGraph graph;
    GraphStore store;
    StringBuilder b = new StringBuilder();
    ArrayList<Identity> uriRes = new ArrayList();
    TIntHashSet blankResources = new TIntHashSet();
    TIntObjectHashMap<String> refNames = new TIntObjectHashMap();
    TIntHashSet parentNameUsed = new TIntHashSet();
    TIntObjectHashMap<String> parentNames = new TIntObjectHashMap();
    TIntHashSet activeResources = new TIntHashSet();
    TIntObjectHashMap<ArrayList<LocalStatement>> localStatements = new TIntObjectHashMap();
    TIntObjectHashMap<String> uris = new TIntObjectHashMap();
    TIntObjectHashMap<String> literals = new TIntObjectHashMap();
    int SimanticsDomain;
    int Layer0;
    int Inherits;
    int InstanceOf;
    int DataType;
    int SubrelationOf;

    GraphUnparser(IGraph graph, GraphStore store) {
        this.graph = graph;
        this.store = store;
    }

    void handleIdentity(Identity id) {
        String name;
        int parent;
        External def;
        int resource = id.resource;
        if (id.definition instanceof External) {
            def = (External)id.definition;
            parent = def.parent;
            name = def.name;
        } else if (id.definition instanceof Internal) {
            def = (Internal)id.definition;
            parent = def.parent;
            name = def.name;
        } else if (id.definition instanceof Optional) {
            def = (Optional)id.definition;
            parent = def.parent;
            name = def.name;
        } else {
            return;
        }
        this.uris.put(id.resource, (Object)(String.valueOf((String)this.uris.get(parent)) + "/" + name));
        if (GraphUnparser.isIdentifier(name)) {
            if (this.parentNames.containsKey(parent)) {
                this.refNames.put(resource, (Object)(String.valueOf((String)this.parentNames.get(parent)) + "." + name));
                this.parentNameUsed.add(parent);
            } else {
                this.refNames.put(resource, (Object)("<" + (String)this.uris.get(resource) + ">"));
            }
            this.parentNames.put(resource, (Object)name);
        } else {
            this.refNames.put(resource, (Object)("<" + (String)this.uris.get(resource) + ">"));
            String[] parts = name.split("-");
            if (GraphUnparser.isIdentifier(parts[0])) {
                this.parentNames.put(resource, (Object)parts[0]);
            }
        }
        if (this.activeResources.remove(resource)) {
            this.uriRes.add(id);
        }
        if (parent == 0) {
            if (name.equals("www.simantics.org")) {
                this.SimanticsDomain = resource;
            }
        } else if (parent == this.SimanticsDomain) {
            if (name.equals("Layer0-1.0")) {
                this.Layer0 = resource;
                this.parentNames.put(resource, (Object)"L0");
            }
        } else if (parent == this.Layer0) {
            if (name.equals("InstanceOf")) {
                this.InstanceOf = resource;
            } else if (name.equals("Inherits")) {
                this.Inherits = resource;
            } else if (name.equals("SubrelationOf")) {
                this.SubrelationOf = resource;
            } else if (name.equals("DataType")) {
                this.DataType = resource;
            }
        }
    }

    void run() {
        final TIntIntHashMap refCount = new TIntIntHashMap();
        this.store.statements.forStatements(new IStatementProcedure(){

            public void execute(int s, int p, int o) {
                ArrayList localStatement;
                if (GraphUnparser.this.activeResources.add(s)) {
                    localStatement = new ArrayList(2);
                    GraphUnparser.this.localStatements.put(s, (Object)localStatement);
                } else {
                    localStatement = (ArrayList)GraphUnparser.this.localStatements.get(s);
                }
                refCount.adjustOrPutValue(p, 1, 1);
                refCount.adjustOrPutValue(o, 1, 1);
                localStatement.add(new LocalStatement(p, o));
            }
        });
        Paths paths = new Paths("1.0");
        this.uris.put(0, (Object)"http:/");
        Identity[] identityArray = this.store.identities.toArray();
        int n = identityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            this.handleIdentity(id);
            ++n2;
        }
        Path dataTypeRes = UriUtils.uriToPath((String)"http://www.simantics.org/Layer0-1.0/DataType");
        Object[] objectArray = this.store.values.toArray();
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Value value = objectArray[n];
            if (this.graph != null) {
                Res res = this.store.idToRes(value.resource);
                if (this.graph.rawGetObjects(res, (Res)paths.InstanceOf).contains(dataTypeRes)) {
                    Binding b = Bindings.getBindingUnchecked(Datatype.class);
                    try {
                        Datatype dt = (Datatype)value.value.getValue(b);
                        this.literals.put(value.resource, (Object)("@" + DataTypePrinter.toString((Datatype)dt, (boolean)false)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Datatype dt = this.graph.getDatatype(res);
                    if (dt != null) {
                        Binding b = Bindings.getBinding((Datatype)dt);
                        try {
                            Object obj = value.value.getValue(b);
                            this.literals.put(value.resource, (Object)b.toString(obj));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.literals.put(value.resource, (Object)("<" + value.value + ">"));
                    }
                }
            }
            ++n;
        }
        int[] nArray = this.activeResources.toArray();
        objectArray = nArray;
        n3 = nArray.length;
        n = 0;
        while (n < n3) {
            Value id = objectArray[n];
            if (refCount.get((int)id) == 1) {
                this.activeResources.remove((int)id);
                this.blankResources.add((int)id);
            }
            ++n;
        }
        int tempId = 0;
        TIntArrayList otherResources = new TIntArrayList();
        int[] nArray2 = this.activeResources.toArray();
        int n4 = nArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            int id = nArray2[n5];
            this.refNames.put(id, (Object)("r" + ++tempId));
            otherResources.add(id);
            ++n5;
        }
        for (Identity uriRe : this.uriRes) {
            this.describeResource(0, uriRe.resource);
        }
        nArray2 = otherResources.toArray();
        n4 = nArray2.length;
        int n6 = 0;
        while (n6 < n4) {
            int id = nArray2[n6];
            this.describeResource(0, id);
            ++n6;
        }
    }

    private void indent(int indentation) {
        int i = 0;
        while (i < indentation) {
            this.b.append("    ");
            ++i;
        }
    }

    private void describeResource(int indentation, int resource) {
        if (this.parentNameUsed.contains(resource)) {
            this.b.append((String)this.parentNames.get(resource));
            this.b.append(" = ");
        }
        if (this.literals.containsKey(resource)) {
            if (this.refNames.get(resource) != null) {
                this.refResource(resource);
                this.b.append(" = ");
            }
            this.b.append((String)this.literals.get(resource));
        } else {
            this.refResource(resource);
        }
        ArrayList<LocalStatement> others = new ArrayList<LocalStatement>();
        for (LocalStatement stat : (ArrayList)this.localStatements.get(resource)) {
            if (!(this.blankResources.contains(stat.object) || stat.predicate != this.InstanceOf && stat.predicate != this.Inherits && stat.predicate != this.SubrelationOf)) {
                this.b.append(' ');
                this.refPredicate(stat.predicate);
                this.b.append(' ');
                this.refResource(stat.object);
                continue;
            }
            others.add(stat);
        }
        this.b.append('\n');
        for (LocalStatement stat : others) {
            this.indent(indentation + 1);
            this.refPredicate(stat.predicate);
            this.b.append(" ");
            this.describeObject(indentation + 1, stat.object);
        }
    }

    private void describeObject(int indentation, int resource) {
        if (this.blankResources.contains(resource)) {
            this.describeResource(indentation, resource);
        } else {
            this.refResource(resource);
            this.b.append('\n');
        }
    }

    private void refPredicate(int resource) {
        if (resource == this.InstanceOf) {
            this.b.append(":");
        } else if (resource == this.Inherits) {
            this.b.append("<T");
        } else if (resource == this.SubrelationOf) {
            this.b.append("<R");
        } else {
            this.refResource(resource);
        }
    }

    private void refResource(int resource) {
        String name = (String)this.refNames.get(resource);
        if (name == null) {
            this.b.append("_");
        } else {
            this.b.append(name);
        }
    }

    public String toString() {
        return this.b.toString();
    }

    static boolean isIdentifier(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String unparse(Paths paths, TransferableGraph1 tg, Collection<TransferableGraph1> dependencies) {
        CompositeGraph cg = TransferableGraphConversion.convert((Paths)paths, dependencies);
        GraphStore store = TransferableGraphConversion.convert((TransferableGraph1)tg);
        cg.addFragment(store);
        GraphUnparser gu = new GraphUnparser((IGraph)cg, store);
        gu.run();
        return gu.toString();
    }
}

