package org.simantics.graph.compiler.internal.store;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.values.TreeValue;
import org.simantics.graph.query.IDataTypeQuery;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;
import org.simantics.graph.store.ValueStore;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;

public class PreValueStore implements IStore {

	TIntObjectHashMap<IPreValue> preValues = new TIntObjectHashMap<IPreValue>();
	TIntHashSet collisions = new TIntHashSet();
	
	@Override
	public void map(TIntIntHashMap map) {
		preValues = IndexMappingUtils.map(map, preValues, collisions);
	}
	
	public void setValue(int id, IPreValue value) {
		preValues.put(id, value);
	}
	
	public void convertPreValues(final ValueStore values, final IDataTypeQuery dtq, final Collection<Problem> problems) {
		preValues.forEachEntry(new TIntObjectProcedure<IPreValue>() {			
			@Override
			public boolean execute(int resource, IPreValue preValue) {
				try {
					Binding binding = dtq.getDataType(resource);
					if(binding == null) {
						problems.add(new Problem(
								preValue.getLocation(), 
								"Literal does not have a data type."
							));	
						return true;
					}
					Object value = preValue.toValue(binding, problems);
					values.setValue(resource,
							new Variant(binding, value)
							);						
				} catch(Exception e) {
					e.printStackTrace();
				}
				return true;
			}
		});
		preValues.clear();
	}
	
	public void forEachPreValue(TIntObjectProcedure<IPreValue> procedure) {
		preValues.forEachEntry(procedure);
	}
	
	public String getStringValue(int i) {
		IPreValue value = preValues.get(i);
		if(value == null || !(value instanceof TreeValue))
			return null;
		ArrayList<Problem> problems = new ArrayList<Problem>();
		String v = (String) ((TreeValue)value).toValue(Bindings.STRING, problems);
		if(v == null || problems.size()>0)
			return null;
		return v;
	}

}
