/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.gnuplot;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.simantics.gnuplot.InputStreamToFileCopier;

public class GnuplotSession
implements Closeable {
    private Process process;
    private PrintStream out;
    private Thread stdoutDumper;
    private Thread stderrDumper;

    GnuplotSession(Path workingDirectory, boolean drainStdout, boolean drainStderr, Process process) {
        this.process = process;
        this.out = new PrintStream(process.getOutputStream());
        if (drainStdout) {
            this.stdoutDumper = new Thread(new InputStreamToFileCopier(process.getInputStream(), null));
            this.stdoutDumper.start();
        }
        if (drainStderr) {
            this.stderrDumper = new Thread(new InputStreamToFileCopier(process.getErrorStream(), null));
            this.stderrDumper.start();
        }
    }

    private void assertAlive() {
        if (this.process == null) {
            throw new IllegalStateException("session has been closed already");
        }
    }

    public void evaluate(String commands) throws IOException {
        this.assertAlive();
        this.out.println(commands);
    }

    public void evaluateStream(InputStream input, String charset) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, charset));){
            String line = br.readLine();
            while (line != null) {
                this.out.println(line);
                this.out.println();
                line = br.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void evaluateFile(Path file) throws IOException {
        try {
            Files.lines(file).forEachOrdered(l -> {
                try {
                    this.evaluate((String)l);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Process p = this.process;
        GnuplotSession gnuplotSession = this;
        synchronized (gnuplotSession) {
            if (this.process == null) {
                return;
            }
            this.process = null;
        }
        this.out.close();
        try {
            if (this.stdoutDumper != null) {
                this.stdoutDumper.join();
            }
            if (this.stderrDumper != null) {
                this.stderrDumper.join();
            }
            p.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

