/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.simantics.scenegraph.utils.TransformedRectangle;

public final class GeometryUtils {
    public static final BasicStroke BASIC_STROKE = new BasicStroke();

    public static BasicStroke scaleStroke(Stroke stroke, float factor) {
        BasicStroke s = (BasicStroke)stroke;
        float[] dash = s.getDashArray();
        if (dash != null) {
            assert (factor != 0.0f);
            dash = GeometryUtils.scaleArray(factor, dash, new float[dash.length]);
        }
        if (dash == null) {
            return new BasicStroke(s.getLineWidth() * factor, s.getEndCap(), s.getLineJoin(), s.getMiterLimit());
        }
        return new BasicStroke(s.getLineWidth() * factor, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), dash, s.getDashPhase() * factor);
    }

    public static float[] scaleArray(float factor, float[] array, float[] targetArray) {
        assert (array != null);
        if (targetArray == null) {
            targetArray = new float[array.length];
        }
        int i = 0;
        while (i < array.length) {
            targetArray[i] = array[i] * factor;
            ++i;
        }
        return targetArray;
    }

    public static Point2D getScaleXY(AffineTransform at, Point2D pt) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        double sx = Math.sqrt(m00 * m00 + m10 * m10);
        double sy = Math.sqrt(m01 * m01 + m11 * m11);
        if (pt == null) {
            pt = new Point2D.Double();
        }
        pt.setLocation(sx, sy);
        return pt;
    }

    public static double getScale(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        return Math.sqrt(Math.abs(m00 * m11 - m10 * m01));
    }

    public static double getMaxScale(AffineTransform at) {
        double m01;
        double m10;
        double determinant;
        double m11;
        double m00 = at.getScaleX();
        double trace = m00 + (m11 = at.getScaleY());
        double dd = trace * trace * 0.25 - (determinant = m00 * m11 - (m10 = at.getShearY()) * (m01 = at.getShearX()));
        if (dd >= 0.0) {
            return Math.abs(trace * 0.5) + Math.sqrt(dd);
        }
        return Math.sqrt(determinant);
    }

    public static boolean intersects(Shape s1, Shape s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1.equals(s2)) {
            return true;
        }
        if (s1 instanceof Rectangle2D) {
            return s2.intersects((Rectangle2D)s1);
        }
        if (s2 instanceof Rectangle2D) {
            return s1.intersects((Rectangle2D)s2);
        }
        if (s1 instanceof TransformedRectangle) {
            return ((TransformedRectangle)s1).intersects(s2);
        }
        if (s2 instanceof TransformedRectangle) {
            return ((TransformedRectangle)s2).intersects(s1);
        }
        Area a1 = new Area(s1);
        Area a2 = new Area(s2);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    public static boolean contains(Shape s1, Shape s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1.equals(s2)) {
            return true;
        }
        if (s2 instanceof Rectangle2D) {
            return s1.contains((Rectangle2D)s2);
        }
        if (s1 instanceof Rectangle2D) {
            return GeometryUtils.contains((Rectangle2D)s1, s2);
        }
        if (s1 instanceof TransformedRectangle) {
            return ((TransformedRectangle)s1).contains(s2);
        }
        Area a1 = new Area(s1);
        Area a2 = new Area(s2);
        a2.subtract(a1);
        return a2.isEmpty();
    }

    public static boolean contains(Rectangle2D r, Shape s) {
        PathIterator pi = s.getPathIterator(null, Double.MAX_VALUE);
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (!(type != 0 && type != 1 || r.contains(coords[0], coords[1]))) {
                return false;
            }
            assert (type != 3 && type != 2);
            pi.next();
        }
        return true;
    }

    public static Shape transformShape(Shape s, AffineTransform t) {
        if (t.isIdentity()) {
            return s;
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)s;
            int type = t.getType();
            if (type == 0) {
                Rectangle2D.Double r = new Rectangle2D.Double();
                r.setFrame(rect);
                return r;
            }
            if ((type & 0x30) != 0) {
                return new TransformedRectangle(rect, t);
            }
            return org.simantics.scenegraph.utils.GeometryUtils.transformRectangle((AffineTransform)t, (Rectangle2D)rect);
        }
        if (s instanceof TransformedRectangle) {
            TransformedRectangle tr = (TransformedRectangle)s;
            TransformedRectangle result = new TransformedRectangle(tr);
            result.concatenate(t);
            return result;
        }
        Area result = new Area(s);
        result.transform(t);
        return result;
    }

    public static double getCompassDirection(Point2D pt) {
        return GeometryUtils.getCompassDirection(pt.getX(), pt.getY());
    }

    public static double getCompassDirection(Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        return GeometryUtils.getCompassDirection(dx, dy);
    }

    public static double getCompassDirection(double x, double y) {
        double rad = Math.atan2(y, x);
        double deg = rad * 180.0 / Math.PI + 90.0;
        if (deg < 0.0) {
            deg += 360.0;
        }
        return deg;
    }

    public static Point2D toUnitVector(double deg, Point2D uv) {
        if (uv == null) {
            uv = new Point2D.Double();
        }
        double x = 0.0;
        double y = 0.0;
        if (deg == 0.0) {
            y = -1.0;
        } else if (deg == 90.0) {
            x = 1.0;
        } else if (deg == 180.0) {
            y = 1.0;
        } else if (deg == 270.0) {
            x = -1.0;
        } else {
            double rad = (deg - 90.0) * Math.PI / 180.0;
            y = Math.sin(rad);
            x = Math.cos(rad);
        }
        uv.setLocation(x, y);
        return uv;
    }

    public static double compassToRad(double deg) {
        double rad = (deg - 90.0) * Math.PI / 180.0;
        return rad;
    }

    public static Color interpolate(Color c1, Color c2, double phase) {
        float r = (float)c1.getRed() / 255.0f * (1.0f - (float)phase) + (float)c2.getRed() / 255.0f * (float)phase;
        float g = (float)c1.getGreen() / 255.0f * (1.0f - (float)phase) + (float)c2.getGreen() / 255.0f * (float)phase;
        float b = (float)c1.getBlue() / 255.0f * (1.0f - (float)phase) + (float)c2.getBlue() / 255.0f * (float)phase;
        float a = (float)c1.getAlpha() / 255.0f * (1.0f - (float)phase) + (float)c2.getAlpha() / 255.0f * (float)phase;
        return new Color(r, g, b, a);
    }

    public static Path2D buildPath(List<Point2D> positions) {
        Path2D.Double result = new Path2D.Double();
        if (positions.size() == 0) {
            return result;
        }
        Point2D pos = positions.get(0);
        ((Path2D)result).moveTo(pos.getX(), pos.getY());
        int i = 1;
        while (i < positions.size()) {
            pos = positions.get(i);
            ((Path2D)result).lineTo(pos.getX(), pos.getY());
            ++i;
        }
        return result;
    }

    public static void getPoints(Path2D path, List<Point2D> positions) {
        PathIterator pi = path.getPathIterator(null);
        double[] mat = new double[6];
        while (!pi.isDone()) {
            pi.currentSegment(mat);
            positions.add(new Point2D.Double(mat[0], mat[1]));
            pi.next();
        }
    }

    public static void main(String[] args) {
        int[] nArray = new int[3];
        nArray[0] = 10;
        nArray[1] = 10;
        int[] nArray2 = new int[3];
        nArray2[1] = 10;
        nArray2[2] = 10;
        Polygon s1 = new Polygon(nArray, nArray2, 3);
        Ellipse2D.Double s2 = new Ellipse2D.Double(0.0, 0.0, 5.0, 5.0);
        Ellipse2D.Double s3 = new Ellipse2D.Double(8.0, 8.0, 4.0, 4.0);
        Rectangle2D.Double s4 = new Rectangle2D.Double(-5.0, 3.0, 20.0, 2.0);
        Rectangle2D.Double s5 = new Rectangle2D.Double(-100.0, -100.0, 200.0, 200.0);
        Ellipse2D.Double s6 = new Ellipse2D.Double(-100.0, -100.0, 200.0, 200.0);
        assert (!GeometryUtils.intersects(s1, s2));
        assert (GeometryUtils.intersects(s1, s3));
        assert (GeometryUtils.intersects(s1, s4));
        assert (GeometryUtils.intersects(s1, s5));
        assert (!GeometryUtils.intersects(s2, s1));
        assert (!GeometryUtils.intersects(s2, s3));
        assert (GeometryUtils.intersects(s2, s4));
        assert (GeometryUtils.intersects(s2, s5));
        assert (GeometryUtils.intersects(s3, s1));
        assert (!GeometryUtils.intersects(s3, s2));
        assert (!GeometryUtils.intersects(s3, s4));
        assert (GeometryUtils.intersects(s3, s5));
        assert (GeometryUtils.intersects(s4, s1));
        assert (GeometryUtils.intersects(s4, s2));
        assert (!GeometryUtils.intersects(s4, s3));
        assert (GeometryUtils.intersects(s4, s5));
        assert (GeometryUtils.intersects(s5, s1));
        assert (GeometryUtils.intersects(s5, s2));
        assert (GeometryUtils.intersects(s5, s3));
        assert (GeometryUtils.intersects(s5, s4));
        assert (!GeometryUtils.contains(s1, (Shape)s2));
        assert (!GeometryUtils.contains(s1, (Shape)s3));
        assert (!GeometryUtils.contains(s1, (Shape)s4));
        assert (!GeometryUtils.contains(s1, (Shape)s5));
        assert (!GeometryUtils.contains(s2, (Shape)s1));
        assert (!GeometryUtils.contains(s2, (Shape)s3));
        assert (!GeometryUtils.contains(s2, (Shape)s4));
        assert (!GeometryUtils.contains(s2, (Shape)s5));
        assert (!GeometryUtils.contains(s3, (Shape)s1));
        assert (!GeometryUtils.contains(s3, (Shape)s2));
        assert (!GeometryUtils.contains(s3, (Shape)s4));
        assert (!GeometryUtils.contains(s3, (Shape)s5));
        assert (!GeometryUtils.contains((Shape)s4, (Shape)s1));
        assert (!GeometryUtils.contains((Shape)s4, (Shape)s2));
        assert (!GeometryUtils.contains((Shape)s4, (Shape)s3));
        assert (!GeometryUtils.contains((Shape)s4, (Shape)s5));
        assert (GeometryUtils.contains((Shape)s5, (Shape)s1));
        assert (GeometryUtils.contains((Shape)s5, (Shape)s2));
        assert (GeometryUtils.contains((Shape)s5, (Shape)s3));
        assert (GeometryUtils.contains((Shape)s5, (Shape)s4));
        assert (GeometryUtils.contains(s6, (Shape)s1));
        assert (GeometryUtils.contains(s6, (Shape)s2));
        assert (GeometryUtils.contains(s6, (Shape)s3));
        assert (GeometryUtils.contains(s6, (Shape)s4));
    }
}

