/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.notification.INotification;
import org.simantics.g2d.notification.INotificationHandle;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.utils.datastructures.hints.IHintContext;

public class Notifications
extends AbstractCanvasParticipant {
    static final double MARGIN = 12.0;
    @DependencyReflection.Reference
    RulerPainter ruler;
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    CanvasBoundsParticipant bounds;
    @DependencyReflection.Dependency
    TimeParticipant time;
    CopyOnWriteArrayList<NotificationHandle> notifications = new CopyOnWriteArrayList();
    public static final int PAINT_PRIORITY = 2147483547;
    public static final IHintContext.Key KEY_NOTIFICATION_LAYOUT = new IHintContext.KeyOf(NotificationLayout.class);
    Rectangle2D r2d = new Rectangle2D.Double();
    G2DParentNode notificationNode;
    private final Set<Node> updated = new HashSet<Node>();

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.setHint(KEY_NOTIFICATION_LAYOUT, new DefaultLayout());
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleTimer(TimeEvent event) {
        if (this.notifications.isEmpty()) {
            this.time.unregisterForEvents(this.getClass());
            return false;
        }
        boolean changes = false;
        ArrayList<NotificationHandle> removed = null;
        for (NotificationHandle n : this.notifications) {
            long elapsed = n.elapsed(event.time);
            if (elapsed > n.duration) {
                changes = true;
                if (removed == null) {
                    removed = new ArrayList<NotificationHandle>();
                }
                removed.add(n);
                continue;
            }
            n.not.setProgress(Notifications.progress(n, event.time));
            changes = true;
        }
        if (changes) {
            if (removed != null) {
                this.notifications.removeAll(removed);
            }
            this.updateNotifications();
            this.setDirty();
        }
        return false;
    }

    public INotificationHandle addNotification(INotification notification, long duration) {
        assert (this.getThread().currentThreadAccess());
        NotificationHandle n = new NotificationHandle(notification, duration);
        this.notifications.add(n);
        this.time.registerForEvents(this.getClass());
        this.setDirty();
        return n;
    }

    public void clearNotification(INotificationHandle handle) {
        assert (this.getThread().currentThreadAccess());
        this.notifications.remove(handle);
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CONTROL)
    public void initSG(G2DParentNode parent) {
        this.notificationNode = (G2DParentNode)parent.addNode("notifications", G2DParentNode.class);
        this.notificationNode.setZIndex(2147483547);
    }

    @SGNodeReflection.SGCleanup
    public void cleanup() {
        if (this.notificationNode != null) {
            this.notificationNode.remove();
            this.notificationNode = null;
        }
    }

    public void updateNotifications() {
        IG2DNode[] nodesCopy;
        G2DParentNode node;
        Rectangle2D cb = this.bounds.getControlBounds();
        double x = cb.getCenterX() + 12.0;
        double y = 12.0;
        double h = 100.0;
        this.updated.clear();
        for (NotificationHandle n : this.notifications) {
            node = (G2DParentNode)this.notificationNode.getOrCreateNode("" + n.not.hashCode(), G2DParentNode.class);
            this.updated.add((Node)node);
            this.r2d.setFrame(x, y, cb.getWidth() / 2.0 - 24.0, h);
            n.not.setBounds(this.r2d);
            n.not.update(node);
            y += h + 12.0;
        }
        Collection nodes = this.notificationNode.getNodes();
        IG2DNode[] iG2DNodeArray = nodesCopy = nodes.toArray(new IG2DNode[nodes.size()]);
        int n = nodesCopy.length;
        int n2 = 0;
        while (n2 < n) {
            node = iG2DNodeArray[n2];
            if (!this.updated.contains(node)) {
                node.remove();
            }
            ++n2;
        }
        this.updated.clear();
    }

    static double progress(NotificationHandle h, long currentTime) {
        long elapsed = h.elapsed(currentTime);
        return Math.min((double)elapsed / (double)h.duration, 1.0);
    }

    class DefaultLayout
    implements NotificationLayout {
        double x = 0.0;
        double y = 0.0;

        DefaultLayout() {
        }

        @Override
        public void rewind() {
            this.x = 0.0;
            this.y = 0.0;
        }

        @Override
        public void setup(INotification n) {
        }
    }

    class NotificationHandle
    implements INotificationHandle {
        INotification not;
        long duration;

        NotificationHandle(INotification not, long duration) {
            this.not = not;
            this.duration = duration;
        }

        @Override
        public void discard() {
            Notifications.this.clearNotification(this);
        }

        public long elapsed(long currentTime) {
            long elapsed = currentTime - this.not.getCreationTime();
            return elapsed;
        }

        @Override
        public boolean hasElapsed() {
            return this.elapsed(System.currentTimeMillis()) > this.duration;
        }
    }

    public static interface NotificationLayout {
        public void rewind();

        public void setup(INotification var1);
    }
}

