/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.BasicStroke;
import java.awt.Color;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.GridNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class GridPainter
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_GRID_ENABLED = new IHintContext.KeyOf(Boolean.class, "GRID_ENABLED");
    public static final IHintContext.Key KEY_GRID_SIZE = new IHintContext.KeyOf(Double.class, "GRID_SIZE");
    private static final double DEFAULT_GRID_SIZE = 1.0;
    public static final BasicStroke GRID_LINE_STROKE = new BasicStroke(0.1f, 2, 2, 10.0f, null, 0.0f);
    IHintListener gridListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ICanvasContext cc = GridPainter.this.getContext();
            if (cc != null) {
                GridPainter.this.updateNode();
                cc.getContentContext().setDirty();
            }
        }
    };
    protected GridNode node = null;

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_GRID_ENABLED, this.gridListener);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_GRID_SIZE, this.gridListener);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_GRID_COLOR, this.gridListener);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_DISABLE_PAINTING, this.gridListener);
        this.getHintStack().addKeyHintListener(this.getThread(), DiagramHints.SNAP_ADVISOR, this.gridListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_GRID_ENABLED, this.gridListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_GRID_SIZE, this.gridListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_GRID_COLOR, this.gridListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_DISABLE_PAINTING, this.gridListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), DiagramHints.SNAP_ADVISOR, this.gridListener);
        super.removedFromContext(ctx);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKeyEvent(CommandEvent e) {
        if (e.command.equals((Object)Commands.GRID_ENABLE)) {
            this.setEnabled(true);
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.GRID_DISABLE)) {
            this.setEnabled(false);
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.GRID_TOGGLE)) {
            this.setEnabled(!this.isGridEnabled());
            this.updateNode();
            this.setDirty();
            return true;
        }
        return false;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (GridNode)parent.addNode("grid", GridNode.class);
        this.node.setLookupId("grid");
        this.node.setZIndex(-2147482648);
        this.updateNode();
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
    }

    protected void updateNode() {
        this.node.setEnabled(Boolean.valueOf(this.isPaintingEnabled()));
        this.node.setGridColor(this.getGridColor());
        this.node.setGridSize(this.getGridSize());
        this.node.setSnapAdvisor((ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR));
    }

    boolean isPaintingEnabled() {
        boolean enabled = this.isGridEnabled();
        Boolean globalDisable = (Boolean)this.getHint(Hints.KEY_DISABLE_PAINTING);
        return enabled && !Boolean.TRUE.equals(globalDisable);
    }

    public boolean isGridEnabled() {
        Boolean enabled = (Boolean)this.getHint(KEY_GRID_ENABLED);
        return !Boolean.FALSE.equals(enabled);
    }

    public void setEnabled(boolean enabled) {
        this.setHint(KEY_GRID_ENABLED, enabled);
    }

    public Color getGridColor() {
        return (Color)this.getHint(Hints.KEY_GRID_COLOR);
    }

    public void setGridColor(int r, int g, int b) {
        this.setGridColor(new Color(r, g, b));
    }

    public void setGridColor(Color c) {
        this.setHint(Hints.KEY_GRID_COLOR, c);
    }

    public double getGridSize() {
        Double d = (Double)this.getHint(KEY_GRID_SIZE);
        return d == null ? 1.0 : d;
    }

    public void setGridSize(double gridSize) {
        this.setHint(KEY_GRID_SIZE, gridSize);
    }
}

