/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.page;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import org.simantics.utils.page.PageCentering;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;

public class SerializablePageDesc
implements Serializable {
    private static final long serialVersionUID = -1992775876802871858L;
    private transient PageDesc desc;

    public SerializablePageDesc(PageDesc desc) {
        this.desc = desc;
    }

    public PageDesc getDesc() {
        return this.desc;
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), this.desc.toString());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.desc.getText());
        out.writeDouble(this.desc.getWidth());
        out.writeDouble(this.desc.getHeight());
        out.writeByte(this.desc.getOrientation().ordinal());
        out.writeByte(this.desc.getCentering().ordinal());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String text = in.readUTF();
        double widthInMM = in.readDouble();
        double heightInMM = in.readDouble();
        byte o = in.readByte();
        byte c = in.readByte();
        PageOrientation[] orientations = PageOrientation.values();
        if (o < 0 || o >= orientations.length) {
            throw new StreamCorruptedException("invalid orientation: " + o);
        }
        PageOrientation orientation = orientations[o];
        PageCentering[] centerings = PageCentering.values();
        if (c < 0 || c >= centerings.length) {
            throw new StreamCorruptedException("invalid centering: " + c);
        }
        PageCentering centering = centerings[c];
        this.desc = new PageDesc(text, orientation, centering, widthInMM, heightInMM);
    }
}

