/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.multileveldiagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.LifeCycle;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.impl.DataElementMapImpl;
import org.simantics.g2d.diagram.handler.impl.PickContextImpl;
import org.simantics.g2d.diagram.handler.impl.TransactionContextImpl;
import org.simantics.g2d.diagram.impl.AbstractDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.AdditionalColor;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.BorderColor;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.TextColor;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.MoveImpl;
import org.simantics.g2d.element.handler.impl.proxy.IProxyProvider;
import org.simantics.g2d.element.handler.impl.proxy.ProxyHandler;
import org.simantics.g2d.element.handler.impl.proxy.ProxyLifeCycle;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.g2d.utils.PathUtils2;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TransitionDiagram
extends AbstractDiagram {
    public static final IHintContext.Key KEY_UPPER_DIAGRAM = new IHintContext.KeyOf(IDiagram.class);
    public static final IHintContext.Key KEY_LOWER_DIAGRAM = new IHintContext.KeyOf(IDiagram.class);
    public static final IHintContext.Key KEY_TRANSITION_CLASS = new IHintContext.KeyOf(ElementClass.class);
    public static final IHintContext.Key KEY_UPPER_ELEMENT = new IHintContext.KeyOf(IElement.class);
    public static final IHintContext.Key KEY_LOWER_ELEMENT = new IHintContext.KeyOf(IElement.class);
    public static final IHintContext.Key KEY_SOURCE_ELEMENT = new IHintContext.KeyOf(IElement.class);
    public static final IHintContext.Key KEY_PHASE = new IHintContext.KeyOf(Double.class);
    public static final ElementClass MORPH_ELEMENT_CLASS = ElementClass.compile(MorphElementHandler.INSTANCE, MoveImpl.HANDLER);
    public static final DiagramClass TRANSITION_DIAGRAM_CLASS = DiagramClass.compile(new PickContextImpl(), new TransactionContextImpl(), new MorphTopologyImpl(), new TransitionDiagramHandler(), new DataElementMapImpl());
    IDiagram upperDiagram;
    IDiagram lowerDiagram;
    private static WeakHashMap<ElementClass, ElementClass> FADEIN_CLASSES = new WeakHashMap();
    private static WeakHashMap<ElementClass, ElementClass> FADEOUT_CLASSES = new WeakHashMap();
    private static final IProxyProvider PROXY_PROVIDER = new IProxyProvider(){

        @Override
        public IElement provide(IElement src) {
            return (IElement)src.getHint(KEY_SOURCE_ELEMENT);
        }
    };

    TransitionDiagram() {
        super(TRANSITION_DIAGRAM_CLASS, (IHintContext)new HintContext());
    }

    public static final IDiagram createTransitionDiagram(IDiagram upperDiagram, IDiagram lowerDiagram, ElementClass transitionClass) {
        assert (upperDiagram != null && lowerDiagram != null && transitionClass != null);
        TransitionDiagram d = new TransitionDiagram();
        d.setHint(KEY_TRANSITION_CLASS, transitionClass);
        d.setHint(KEY_UPPER_DIAGRAM, upperDiagram);
        d.setHint(KEY_LOWER_DIAGRAM, lowerDiagram);
        d.fireCreated();
        return d;
    }

    private static IElement setElementClass(IElement e, ElementClass clazz) {
        IDiagram d = e.getDiagram();
        if (e.getElementClass().equals(clazz)) {
            return e;
        }
        Map hints = e.getHints();
        int index = d.getElements().indexOf(e);
        d.removeElement(e);
        e.destroy();
        e = Element.spawnNew(clazz);
        e.setHints(hints);
        d.addElement(e);
        d.moveTo(e, index);
        return e;
    }

    public static synchronized ElementClass getFadeElementClass(ElementClass origClass, ProxyFadePaint.FadeDir dir) {
        if (dir == ProxyFadePaint.FadeDir.In) {
            ElementClass proxyClass = FADEIN_CLASSES.get(origClass);
            if (proxyClass == null) {
                proxyClass = TransitionDiagram.createFadeElementClass(origClass, dir);
                FADEIN_CLASSES.put(origClass, proxyClass);
            }
            return proxyClass;
        }
        ElementClass proxyClass = FADEOUT_CLASSES.get(origClass);
        if (proxyClass == null) {
            proxyClass = TransitionDiagram.createFadeElementClass(origClass, dir);
            FADEOUT_CLASSES.put(origClass, proxyClass);
        }
        return proxyClass;
    }

    static ElementClass createFadeElementClass(ElementClass clazz, ProxyFadePaint.FadeDir dir) {
        ArrayList<ElementHandler> result = new ArrayList<ElementHandler>();
        ArrayList<ElementHandler> lst = new ArrayList<ElementHandler>();
        for (ElementHandler eh : clazz.getAll()) {
            lst.clear();
            ProxyHandler.addProxyElementHandlers(eh, PROXY_PROVIDER, lst);
            for (ElementHandler eh2 : lst) {
                if (eh2 instanceof ProxyLifeCycle || eh2 instanceof TerminalTopology) continue;
                if (eh2 instanceof SceneGraph) {
                    result.add(new ProxyFadePaint(dir, (SceneGraph)eh));
                    continue;
                }
                result.add(eh2);
            }
        }
        return ElementClass.compile(result);
    }

    static class MorphElementHandler
    implements SceneGraph,
    FillColor,
    BorderColor,
    AdditionalColor,
    TextColor,
    Transform,
    InternalSize,
    EdgeVisuals,
    BendsHandler,
    Text {
        private static final long serialVersionUID = 1907473087657477787L;
        public static final MorphElementHandler INSTANCE = new MorphElementHandler();
        public static final IHintContext.Key KEY_ELEMENT_MAP = new IHintContext.KeyOf(Map.class);

        MorphElementHandler() {
        }

        static IElement getUpperSourceElement(IElement e) {
            return (IElement)e.getHint(KEY_UPPER_ELEMENT);
        }

        static IElement getLowerSourceElement(IElement e) {
            return (IElement)e.getHint(KEY_LOWER_ELEMENT);
        }

        static Transition getTransition(IElement e) {
            Transition t = new Transition();
            Double phase = (Double)e.getDiagram().getHint(KEY_PHASE);
            t.le = MorphElementHandler.getLowerSourceElement(e);
            t.ue = MorphElementHandler.getUpperSourceElement(e);
            t.phase = phase;
            return t;
        }

        @Override
        public AffineTransform getTransform(IElement e) {
            AffineTransform lat;
            Transition t = MorphElementHandler.getTransition(e);
            Transform ut = t.ue == null ? null : t.ue.getElementClass().getAtMostOneItemOfClass(Transform.class);
            Transform lt = t.le == null ? null : t.le.getElementClass().getAtMostOneItemOfClass(Transform.class);
            AffineTransform uat = ut == null ? null : ut.getTransform(t.ue);
            AffineTransform affineTransform = lat = lt == null ? null : lt.getTransform(t.le);
            if (uat == null) {
                return lat;
            }
            if (lat == null) {
                return uat;
            }
            double[] um = new double[6];
            uat.getMatrix(um);
            double[] lm = new double[6];
            lat.getMatrix(lm);
            double[] rm = new double[6];
            int i = 0;
            while (i < 6) {
                rm[i] = um[i] * (1.0 - t.phase) + lm[i] * t.phase;
                ++i;
            }
            return new AffineTransform(rm);
        }

        @Override
        public void setTransform(IElement e, AffineTransform at) {
        }

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Rectangle2D ls;
            Transition t = MorphElementHandler.getTransition(e);
            InternalSize ub = t.ue == null ? null : t.ue.getElementClass().getAtMostOneItemOfClass(InternalSize.class);
            InternalSize lb = t.le == null ? null : t.le.getElementClass().getAtMostOneItemOfClass(InternalSize.class);
            Rectangle2D us = ub == null ? null : ub.getBounds(t.ue, null);
            Rectangle2D rectangle2D = ls = lb == null ? null : lb.getBounds(t.le, null);
            if (ls == null && us == null) {
                return null;
            }
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            if (ls == null && us != null) {
                size.setRect(us);
                return size;
            }
            if (us == null && ls != null) {
                size.setRect(ls);
                return size;
            }
            double minX = us.getMinX() * (1.0 - t.phase) + ls.getMinX() * t.phase;
            double minY = us.getMinY() * (1.0 - t.phase) + ls.getMinY() * t.phase;
            double maxX = us.getMaxX() * (1.0 - t.phase) + ls.getMaxX() * t.phase;
            double maxY = us.getMaxY() * (1.0 - t.phase) + ls.getMaxY() * t.phase;
            size.setRect(minX, minY, maxX - minX, maxY - minY);
            return size;
        }

        @Override
        public double getArrowSize(IElement e, EdgeVisuals.EdgeEnd end) {
            Transition t = MorphElementHandler.getTransition(e);
            EdgeVisuals uev = t.ue == null ? null : t.ue.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            EdgeVisuals lev = t.le == null ? null : t.le.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            double us = uev == null ? 0.0 : uev.getArrowSize(t.ue, end);
            double ls = lev == null ? 0.0 : lev.getArrowSize(t.le, end);
            return us * (1.0 - t.phase) + ls * t.phase;
        }

        @Override
        public EdgeVisuals.StrokeType getStrokeType(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            EdgeVisuals uev = t.ue.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            EdgeVisuals lev = t.le.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            EdgeVisuals.StrokeType ust = uev == null ? null : uev.getStrokeType(t.ue);
            EdgeVisuals.StrokeType lst = lev == null ? null : lev.getStrokeType(t.le);
            return ust == null ? lst : ust;
        }

        @Override
        public EdgeVisuals.ArrowType getArrowType(IElement e, EdgeVisuals.EdgeEnd end) {
            Transition t = MorphElementHandler.getTransition(e);
            EdgeVisuals uev = t.ue.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            EdgeVisuals lev = t.le.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            EdgeVisuals.ArrowType uat = uev == null ? null : uev.getArrowType(t.ue, end);
            EdgeVisuals.ArrowType lat = lev == null ? null : lev.getArrowType(t.le, end);
            return uat == null ? lat : uat;
        }

        @Override
        public Stroke getStroke(IElement e) {
            Stroke ls;
            Transition t = MorphElementHandler.getTransition(e);
            EdgeVisuals uev = t.ue == null ? null : t.ue.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            EdgeVisuals lev = t.le == null ? null : t.le.getElementClass().getAtMostOneItemOfClass(EdgeVisuals.class);
            Stroke us = uev == null ? null : uev.getStroke(t.ue);
            Stroke stroke = ls = lev == null ? null : lev.getStroke(t.le);
            if (us == null) {
                return ls;
            }
            if (ls == null) {
                return us;
            }
            if (!(us instanceof BasicStroke) || !(ls instanceof BasicStroke)) {
                return us;
            }
            BasicStroke bsu = (BasicStroke)us;
            BasicStroke bsl = (BasicStroke)ls;
            double width = (double)bsu.getLineWidth() * (1.0 - t.phase) + (double)bsl.getLineWidth() * t.phase;
            return new BasicStroke((float)width, bsu.getEndCap(), bsu.getLineJoin(), bsu.getMiterLimit(), bsu.getDashArray(), bsu.getDashPhase());
        }

        @Override
        public void setArrowSize(IElement e, EdgeVisuals.EdgeEnd end, double size) {
        }

        @Override
        public void setStrokeType(IElement e, EdgeVisuals.StrokeType arrowType) {
        }

        @Override
        public void setArrowType(IElement e, EdgeVisuals.EdgeEnd end, EdgeVisuals.ArrowType arrowType) {
        }

        @Override
        public void setStroke(IElement e, Stroke s) {
        }

        @Override
        public String getText(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            Text tu = t.ue == null ? null : t.ue.getElementClass().getAtMostOneItemOfClass(Text.class);
            Text tl = t.le == null ? null : t.le.getElementClass().getAtMostOneItemOfClass(Text.class);
            String su = tu == null ? null : tu.getText(t.ue);
            String sl = tl == null ? null : tl.getText(t.le);
            return su == null ? sl : su;
        }

        @Override
        public void setText(IElement e, String text) {
        }

        @Override
        public Color getFillColor(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            Color uc = ElementUtils.getFillColor(t.ue);
            Color lc = ElementUtils.getFillColor(t.le);
            if (uc == null) {
                return lc;
            }
            if (lc == null) {
                return uc;
            }
            return GeometryUtils.interpolate(uc, lc, t.phase);
        }

        @Override
        public void setFillColor(IElement e, Color c) {
        }

        @Override
        public Color getBorderColor(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            Color uc = ElementUtils.getBorderColor(t.ue);
            Color lc = ElementUtils.getBorderColor(t.le);
            if (uc == null) {
                return lc;
            }
            if (lc == null) {
                return uc;
            }
            return GeometryUtils.interpolate(uc, lc, t.phase);
        }

        @Override
        public void setBorderColor(IElement e, Color c) {
        }

        @Override
        public Color getAdditionalColor(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            Color uc = ElementUtils.getAdditionalColor(t.ue);
            Color lc = ElementUtils.getAdditionalColor(t.le);
            if (uc == null) {
                return lc;
            }
            if (lc == null) {
                return uc;
            }
            return GeometryUtils.interpolate(uc, lc, t.phase);
        }

        @Override
        public void setAdditionalColor(IElement e, Color c) {
        }

        @Override
        public Color getTextColor(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            Color uc = ElementUtils.getTextColor(t.ue);
            Color lc = ElementUtils.getTextColor(t.le);
            if (uc == null) {
                return lc;
            }
            if (lc == null) {
                return uc;
            }
            return GeometryUtils.interpolate(uc, lc, t.phase);
        }

        @Override
        public void setTextColor(IElement e, Color c) {
        }

        @Override
        public BendsHandler.AngleType getAngleType(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            BendsHandler ueb = t.ue.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            BendsHandler leb = t.le.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (ueb != null) {
                return ueb.getAngleType(t.ue);
            }
            if (leb != null) {
                return leb.getAngleType(t.le);
            }
            return null;
        }

        @Override
        public void setAngleType(IElement e, BendsHandler.AngleType angleType) {
        }

        @Override
        public BendsHandler.Bend addBend(IElement e, int index, Point2D pos) {
            return null;
        }

        @Override
        public void getBendPosition(IElement e, BendsHandler.Bend b, Point2D pos) {
            Transition t = MorphElementHandler.getTransition(e);
            BendsHandler ueb = t.ue.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            BendsHandler leb = t.le.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (ueb != null) {
                ueb.getBendPosition(e, b, pos);
            }
            if (leb != null) {
                leb.getBendPosition(e, b, pos);
            }
        }

        @Override
        public void getBends(IElement e, List<BendsHandler.Bend> bends) {
            Transition t = MorphElementHandler.getTransition(e);
            BendsHandler ueb = t.ue.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            BendsHandler leb = t.le.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (ueb != null) {
                ueb.getBends(e, bends);
            }
            if (leb != null) {
                leb.getBends(e, bends);
            }
        }

        @Override
        public boolean removeBend(IElement e, BendsHandler.Bend b) {
            return false;
        }

        @Override
        public Path2D getPath(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            BendsHandler ueb = t.ue.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            BendsHandler leb = t.le.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (ueb == null && leb == null) {
                return null;
            }
            if (ueb == null) {
                return leb.getPath(t.le);
            }
            if (leb == null) {
                return ueb.getPath(t.ue);
            }
            Path2D up = ueb.getPath(t.ue);
            Path2D lp = leb.getPath(t.le);
            return PathUtils2.interpolatePaths(up, lp, t.phase);
        }

        @Override
        public void setPath(IElement e, Path2D p) {
        }

        @Override
        public int getBendsCount(IElement e) {
            Transition t = MorphElementHandler.getTransition(e);
            BendsHandler ueb = t.ue.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            BendsHandler leb = t.le.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (leb != null) {
                return leb.getBendsCount(t.le);
            }
            if (ueb != null) {
                return ueb.getBendsCount(t.ue);
            }
            return 0;
        }

        @Override
        public void moveBend(IElement e, BendsHandler.Bend b, Point2D pos) {
        }

        @Override
        public void cleanup(IElement e) {
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            List<SceneGraph> lps;
            Transition t = MorphElementHandler.getTransition(e);
            List<SceneGraph> empty = Collections.EMPTY_LIST;
            List<SceneGraph> ups = t.ue == null ? empty : t.ue.getElementClass().getItemsByClass(SceneGraph.class);
            List<SceneGraph> list = lps = t.le == null ? empty : t.le.getElementClass().getItemsByClass(SceneGraph.class);
            if (ObjectUtils.equals(ups, lps)) {
                for (SceneGraph lp : lps) {
                    lp.init(e, parent);
                }
                return;
            }
            if (!lps.isEmpty()) {
                for (SceneGraph lp : lps) {
                    lp.init(t.le, parent);
                }
            }
            if (!ups.isEmpty()) {
                for (SceneGraph up : ups) {
                    up.init(t.ue, parent);
                }
            }
        }

        private static class Transition {
            IElement ue;
            IElement le;
            double phase;

            private Transition() {
            }
        }
    }

    static class MorphTopologyImpl
    implements Topology {
        MorphTopologyImpl() {
        }

        @Override
        public void connect(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Topology.Terminal terminal) {
        }

        @Override
        public void disconnect(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Topology.Terminal terminal) {
        }

        @Override
        public Topology.Connection getConnection(IElement edge, EdgeVisuals.EdgeEnd end) {
            return null;
        }

        @Override
        public void getConnections(IElement node, Topology.Terminal terminal, Collection<Topology.Connection> connections) {
        }
    }

    static class ProxyFadePaint
    implements SceneGraph {
        private static final long serialVersionUID = 3559624682436513231L;
        FadeDir dir;
        SceneGraph orig;

        public ProxyFadePaint(FadeDir dir, SceneGraph orig) {
            this.dir = dir;
            this.orig = orig;
            assert (orig != null);
        }

        public static IElement getSource(IElement element) {
            return (IElement)element.getHint(KEY_SOURCE_ELEMENT);
        }

        public double getPhase(IElement element) {
            Double phase = (Double)element.getDiagram().getHint(KEY_PHASE);
            if (phase == null) {
                phase = 0.0;
            }
            if (this.dir == FadeDir.Out) {
                phase = 1.0 - phase;
            }
            return phase;
        }

        @Override
        public void cleanup(IElement e) {
            IElement sourceElement = ProxyFadePaint.getSource(e);
            this.orig.cleanup(sourceElement);
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            IElement sourceElement = ProxyFadePaint.getSource(e);
            this.orig.init(sourceElement, parent);
        }

        static enum FadeDir {
            In,
            Out;

        }
    }

    static class TransitionDiagramHandler
    implements LifeCycle {
        private static final IHintContext.Key KEY_COMPOSITION_LISTENER = new IHintContext.KeyOf(IDiagram.CompositionListener.class);

        TransitionDiagramHandler() {
        }

        @Override
        public void onDiagramCreated(final IDiagram transitionDiagram) {
            IDiagram.CompositionListener cl = new IDiagram.CompositionListener(){

                @Override
                public void onElementAdded(IDiagram diagram, IElement element) {
                    ElementClass clazz;
                    IElement counterPart;
                    IDiagram upperDiagram = (IDiagram)transitionDiagram.getHint(KEY_UPPER_DIAGRAM);
                    IDiagram lowerDiagram = (IDiagram)transitionDiagram.getHint(KEY_LOWER_DIAGRAM);
                    boolean isUpper = diagram == upperDiagram;
                    IDiagram oppositeDiagram = isUpper ? lowerDiagram : upperDiagram;
                    DataElementMap m = diagram.getDiagramClass().getSingleItem(DataElementMap.class);
                    Object data = m.getData(diagram, element);
                    m = oppositeDiagram.getDiagramClass().getSingleItem(DataElementMap.class);
                    IElement iElement = counterPart = data == null ? null : m.getElement(oppositeDiagram, data);
                    if (counterPart != null) {
                        clazz = MORPH_ELEMENT_CLASS;
                    } else {
                        ProxyFadePaint.FadeDir dir = isUpper ? ProxyFadePaint.FadeDir.Out : ProxyFadePaint.FadeDir.In;
                        clazz = TransitionDiagram.getFadeElementClass(element.getElementClass(), dir);
                    }
                    m = transitionDiagram.getDiagramClass().getSingleItem(DataElementMap.class);
                    IElement transitionElement = m.getElement(transitionDiagram, data);
                    if (transitionElement != null) {
                        TransitionDiagram.setElementClass(transitionElement, clazz);
                        return;
                    }
                    transitionElement = Element.instantiate(clazz, null);
                    if (counterPart != null) {
                        transitionElement.setHint(KEY_UPPER_ELEMENT, isUpper ? element : counterPart);
                        transitionElement.setHint(KEY_LOWER_ELEMENT, isUpper ? counterPart : element);
                    } else {
                        transitionElement.setHint(KEY_SOURCE_ELEMENT, element);
                    }
                    if (data != null) {
                        transitionElement.setHint(ElementHints.KEY_OBJECT, data);
                    }
                    Element.fireCreated(transitionElement);
                    transitionDiagram.addElement(transitionElement);
                }

                @Override
                public void onElementRemoved(IDiagram diagram, IElement element) {
                    IDiagram upperDiagram = (IDiagram)transitionDiagram.getHint(KEY_UPPER_DIAGRAM);
                    IDiagram lowerDiagram = (IDiagram)transitionDiagram.getHint(KEY_LOWER_DIAGRAM);
                    boolean isUpper = diagram == upperDiagram;
                    IDiagram oppositeDiagram = isUpper ? lowerDiagram : upperDiagram;
                    DataElementMap m = diagram.getDiagramClass().getSingleItem(DataElementMap.class);
                    Object data = m.getData(diagram, element);
                    m = oppositeDiagram.getDiagramClass().getSingleItem(DataElementMap.class);
                    IElement counterPart = data == null ? null : m.getElement(oppositeDiagram, data);
                    m = transitionDiagram.getDiagramClass().getSingleItem(DataElementMap.class);
                    IElement transitionElement = m.getElement(transitionDiagram, data);
                    if (transitionElement == null) {
                        for (IElement e : transitionDiagram.getElements()) {
                            if (e.getHint(KEY_SOURCE_ELEMENT) != element) continue;
                            transitionElement = e;
                            break;
                        }
                    }
                    if (transitionElement == null) {
                        return;
                    }
                    if (transitionElement.getElementClass().equals(MORPH_ELEMENT_CLASS) && counterPart != null) {
                        ProxyFadePaint.FadeDir dir = isUpper ? ProxyFadePaint.FadeDir.Out : ProxyFadePaint.FadeDir.In;
                        ElementClass clazz = TransitionDiagram.getFadeElementClass(element.getElementClass(), dir);
                        transitionElement.removeHint(KEY_UPPER_ELEMENT);
                        transitionElement.removeHint(KEY_LOWER_ELEMENT);
                        TransitionDiagram.setElementClass(transitionElement, clazz);
                        transitionElement.setHint(KEY_SOURCE_ELEMENT, counterPart);
                    } else {
                        transitionDiagram.removeElement(transitionElement);
                        transitionElement.destroy();
                    }
                }
            };
            IDiagram upperDiagram = (IDiagram)transitionDiagram.getHint(KEY_UPPER_DIAGRAM);
            IDiagram lowerDiagram = (IDiagram)transitionDiagram.getHint(KEY_LOWER_DIAGRAM);
            upperDiagram.addCompositionListener(cl);
            lowerDiagram.addCompositionListener(cl);
            transitionDiagram.setHint(KEY_COMPOSITION_LISTENER, cl);
            for (IElement e : upperDiagram.getElements()) {
                cl.onElementAdded(upperDiagram, e);
            }
            for (IElement e : lowerDiagram.getElements()) {
                cl.onElementAdded(lowerDiagram, e);
            }
        }

        @Override
        public void onDiagramDisposed(IDiagram diagram) {
            IDiagram.CompositionListener cl = (IDiagram.CompositionListener)diagram.getHint(KEY_COMPOSITION_LISTENER);
            IDiagram upperDiagram = (IDiagram)diagram.getHint(KEY_UPPER_DIAGRAM);
            IDiagram lowerDiagram = (IDiagram)diagram.getHint(KEY_LOWER_DIAGRAM);
            upperDiagram.removeCompositionListener(cl);
            lowerDiagram.removeCompositionListener(cl);
            diagram.removeHint(KEY_COMPOSITION_LISTENER);
        }

        @Override
        public void onDiagramDestroyed(IDiagram diagram) {
        }

        @Override
        public void onDiagramLoaded(IDiagram diagram, Collection<IElement> initialElements) {
        }
    }
}

