/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.layers;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.layers.SimpleLayer;

public class SimpleLayers
implements ILayersEditor {
    private static final Comparator<ILayer> LAYER_COMPARATOR = new Comparator<ILayer>(){

        @Override
        public int compare(ILayer o1, ILayer o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private Set<ILayer> all = new TreeSet<ILayer>(LAYER_COMPARATOR);
    private volatile Set<ILayer> allSnapshot;
    private Set<ILayer> visible = new TreeSet<ILayer>(LAYER_COMPARATOR);
    private volatile Set<ILayer> visibleSnapshot;
    private CopyOnWriteArrayList<ILayersEditor.ILayersEditorListener> listeners = new CopyOnWriteArrayList();
    private boolean ignoreFocusSettings = false;
    private boolean ignoreVisibilitySettings = false;

    public SimpleLayers() {
    }

    public SimpleLayers(String ... content) {
        String[] stringArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            SimpleLayer layer = new SimpleLayer(s);
            this.all.add(layer);
            this.visible.add(layer);
            ++n2;
        }
        this.allSnapshot = null;
        this.visibleSnapshot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ILayer> getLayers() {
        if (this.allSnapshot == null) {
            SimpleLayers simpleLayers = this;
            synchronized (simpleLayers) {
                if (this.allSnapshot == null) {
                    TreeSet<ILayer> ss = new TreeSet<ILayer>(LAYER_COMPARATOR);
                    ss.addAll(this.all);
                    this.allSnapshot = Collections.unmodifiableSet(ss);
                }
            }
        }
        return this.allSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ILayer> getVisibleLayers() {
        if (this.visibleSnapshot == null) {
            SimpleLayers simpleLayers = this;
            synchronized (simpleLayers) {
                if (this.visibleSnapshot == null) {
                    TreeSet<ILayer> ss = new TreeSet<ILayer>(LAYER_COMPARATOR);
                    ss.addAll(this.visible);
                    this.visibleSnapshot = Collections.unmodifiableSet(ss);
                }
            }
        }
        return this.visibleSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(ILayer layer) {
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            return this.visible.contains(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate(ILayer layer) {
        boolean deactivated = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            deactivated = this.visible.remove(layer);
        }
        if (deactivated) {
            simpleLayers = this;
            synchronized (simpleLayers) {
                this.visibleSnapshot = null;
            }
            for (ILayersEditor.ILayersEditorListener listener : this.listeners) {
                listener.layerDeactivated(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(ILayer layer) {
        boolean activated = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            activated = this.visible.add(layer);
        }
        if (activated) {
            simpleLayers = this;
            synchronized (simpleLayers) {
                this.visibleSnapshot = null;
            }
            for (ILayersEditor.ILayersEditorListener listener : this.listeners) {
                listener.layerActivated(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayer(ILayer layer) {
        boolean added = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            added = this.all.add(layer);
        }
        if (added) {
            simpleLayers = this;
            synchronized (simpleLayers) {
                this.allSnapshot = null;
            }
            for (ILayersEditor.ILayersEditorListener listener : this.listeners) {
                listener.layerAdded(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayer(ILayer layer) {
        boolean removed = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            removed = this.all.remove(layer);
            this.visible.remove(layer);
        }
        if (removed) {
            simpleLayers = this;
            synchronized (simpleLayers) {
                this.allSnapshot = null;
                this.visibleSnapshot = null;
            }
            for (ILayersEditor.ILayersEditorListener listener : this.listeners) {
                listener.layerRemoved(layer);
            }
        }
    }

    @Override
    public void addListener(ILayersEditor.ILayersEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ILayersEditor.ILayersEditorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean getIgnoreFocusSettings() {
        return this.ignoreFocusSettings;
    }

    @Override
    public void setIgnoreFocusSettings(boolean value) {
        boolean changed = this.ignoreFocusSettings ^ value;
        this.ignoreFocusSettings = value;
        if (changed) {
            for (ILayersEditor.ILayersEditorListener listener : this.listeners) {
                listener.ignoreFocusChanged(value);
            }
        }
    }

    @Override
    public boolean getIgnoreVisibilitySettings() {
        return this.ignoreVisibilitySettings;
    }

    @Override
    public void setIgnoreVisibilitySettings(boolean value) {
        boolean changed = this.ignoreVisibilitySettings ^ value;
        this.ignoreVisibilitySettings = value;
        if (changed) {
            for (ILayersEditor.ILayersEditorListener listener : this.listeners) {
                listener.ignoreVisibilityChanged(value);
            }
        }
    }
}

