/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.event.adapter;

import java.awt.geom.Point2D;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Point;
import org.simantics.g2d.event.adapter.SWTKeyEventAdapter;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.adapter.AbstractEventAdapter;
import org.simantics.utils.ui.SWTDPIUtil;

public class SWTMouseEventAdapter
extends AbstractEventAdapter
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
MouseWheelListener {
    public static final int MOUSE_ID = 0;
    private long[] pressTime = new long[5];
    int buttonStatus = 0;

    public SWTMouseEventAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public SWTMouseEventAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    private Point2D getControlPosition(MouseEvent e) {
        return new Point2D.Double(SWTDPIUtil.upscaleSwt((int)e.x), SWTDPIUtil.upscaleSwt((int)e.y));
    }

    private Point2D getScreenPosition(MouseEvent e) {
        Point p = SWTDPIUtil.upscaleSwt((Point)e.display.getCursorLocation());
        return new Point2D.Double(p.x, p.y);
    }

    private int getMouseButton(MouseEvent e) {
        switch (e.button) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return e.button;
    }

    private static int getStateMask(MouseEvent e) {
        return SWTKeyEventAdapter.adaptSWTModifierToAWTModifier(e.stateMask);
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.handleEvent((Event)new MouseEvent.MouseDoubleClickedEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getMouseButton(e), this.getControlPosition(e), this.getScreenPosition(e)));
    }

    public void mouseDown(MouseEvent e) {
        this.buttonStatus |= 1 << e.button;
        if (e.button <= this.pressTime.length) {
            this.pressTime[e.button - 1] = e.time & 0xFFFFFFFF;
        }
        this.handleEvent((Event)new MouseEvent.MouseButtonPressedEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getMouseButton(e), this.getControlPosition(e), this.getScreenPosition(e)));
    }

    public void mouseUp(MouseEvent e) {
        this.buttonStatus &= ~(1 << e.button);
        long holdTime = Long.MAX_VALUE;
        if (e.button <= this.pressTime.length) {
            holdTime = (long)(e.time & 0xFFFFFFFF) - this.pressTime[e.button - 1];
        }
        this.handleEvent((Event)new MouseEvent.MouseButtonReleasedEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getMouseButton(e), holdTime, this.getControlPosition(e), this.getScreenPosition(e)));
    }

    public void mouseMove(MouseEvent e) {
        MouseEvent.MouseMovedEvent mme = new MouseEvent.MouseMovedEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e));
        this.handleEvent((Event)mme);
    }

    public void mouseEnter(MouseEvent e) {
        this.handleEvent((Event)new MouseEvent.MouseEnterEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e)));
    }

    public void mouseExit(MouseEvent e) {
        this.handleEvent((Event)new MouseEvent.MouseExitEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e)));
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        this.handleEvent((Event)new MouseEvent.MouseWheelMovedEvent(this.sender, (long)(e.time & 0xFFFFFFFF), 0, this.buttonStatus, SWTMouseEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e), 0, 0, e.count));
    }
}

