/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TransitionFunctionPainter
implements SceneGraph {
    private static final long serialVersionUID = 218125859645762515L;
    TransitionFunction func;
    Path2D path;
    static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

    public TransitionFunctionPainter(TransitionFunction func) {
        this.func = func;
        this.path = new Path2D.Double();
        int i = 0;
        while (i < 101) {
            double x = (double)i / 100.0;
            double y = func.f(x);
            if (i == 0) {
                this.path.moveTo(x, 1.0 - y);
            } else {
                this.path.lineTo(x, 1.0 - y);
            }
            ++i;
        }
    }

    @Override
    public void cleanup(IElement e) {
        Node node = (Node)e.removeHint(SG_NODE);
        if (node != null) {
            node.remove();
        }
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        ShapeNode node = (ShapeNode)e.getHint(SG_NODE);
        if (node == null) {
            node = (ShapeNode)parent.addNode(ShapeNode.class);
            e.setHint(SG_NODE, node);
        }
        Rectangle2D bounds = ElementUtils.getElementBounds(e);
        AffineTransform transform = AffineTransform.getTranslateInstance(-bounds.getMinX(), -bounds.getMinY());
        transform.scale(bounds.getWidth(), bounds.getHeight());
        node.setTransform(transform);
        node.setStroke((Stroke)STROKE);
        node.setScaleStroke(true);
        node.setColor((Paint)Color.BLACK);
        node.setShape((Shape)this.path);
    }
}

