/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.utils.datastructures.ValueUtils;

public class StaticTerminals
implements TerminalLayout,
TerminalTopology {
    private static final long serialVersionUID = -7324592260579191478L;
    Map<Topology.Terminal, TerminalImpl> terminalMap = new HashMap<Topology.Terminal, TerminalImpl>();
    ArrayList<Topology.Terminal> terminals = new ArrayList();

    public static TerminalLayout compile(Object ... xytArray) {
        return new StaticTerminals(xytArray);
    }

    StaticTerminals(Object ... xytArray) {
        assert (xytArray.length % 4 == 0);
        int i = 0;
        while (i < xytArray.length / 4) {
            DirectionSet ds;
            TerminalImpl ti = new TerminalImpl();
            ti.t = (Topology.Terminal)xytArray[i * 4 + 0];
            ti.x = ValueUtils.toDoubleScalar((Object)xytArray[i * 4 + 1]);
            ti.y = ValueUtils.toDoubleScalar((Object)xytArray[i * 4 + 2]);
            ti.ds = ds = (DirectionSet)xytArray[i * 4 + 3];
            this.terminals.add(ti.t);
            this.terminalMap.put(ti.t, ti);
            ++i;
        }
    }

    @Override
    public AffineTransform getTerminalPosition(IElement node, Topology.Terminal t) {
        TerminalImpl ti = this.terminalMap.get(t);
        if (ti == null) {
            return null;
        }
        AffineTransform result = new AffineTransform();
        result.setToTranslation(ti.x, ti.y);
        return result;
    }

    @Override
    public void getTerminals(IElement e, Collection<Topology.Terminal> result) {
        result.addAll(this.terminals);
    }

    @Override
    public boolean getTerminalDirection(IElement node, Topology.Terminal t, DirectionSet directions) {
        TerminalImpl ti = this.terminalMap.get(t);
        if (ti == null) {
            return false;
        }
        directions.addAll(ti.ds);
        return true;
    }

    @Override
    public Shape getTerminalShape(IElement node, Topology.Terminal t) {
        return null;
    }

    private class TerminalImpl
    implements Topology.Terminal {
        double x;
        double y;
        DirectionSet ds;
        Topology.Terminal t;

        private TerminalImpl() {
        }
    }
}

