/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.chassis.AbstractChassis;
import org.simantics.scenegraph.g2d.G2DRenderingHints;

public class ImageChassis
extends AbstractChassis {
    public static final Color WIPE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color backgroundColor;
    Image image;
    boolean dirty = false;

    public ImageChassis(Image image) {
        this.image = image;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Point2D getSize() {
        return new Point2D.Double(this.image.getWidth(null), this.image.getHeight(null));
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.image.getWidth(null), this.image.getHeight(null));
    }

    @Override
    public void setCanvasContext(ICanvasContext canvasContext) {
        super.setCanvasContext(canvasContext);
        canvasContext.getContentContext().addPaintableContextListener(new IContentContext.IContentListener(){

            @Override
            public void onDirty(IContentContext sender) {
                if (ImageChassis.this.dirty) {
                    return;
                }
                ImageChassis.this.dirty = true;
                ImageChassis.this.draw();
            }
        });
        this.draw();
    }

    public void draw() {
        if (this.canvasContext.isLocked()) {
            throw new IllegalStateException("cannot draw image, canvas context is locked: " + this.canvasContext);
        }
        this.dirty = false;
        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
        try {
            g2d.setRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_CONTROL_BOUNDS, this.getBounds());
            if (this.backgroundColor != null) {
                Rectangle2D bounds = this.getBounds();
                g2d.setBackground(this.backgroundColor);
                g2d.clearRect(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
            }
            this.canvasContext.getSceneGraph().render(g2d);
        }
        finally {
            g2d.dispose();
        }
    }
}

