/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.IDiagram.CompositionListener;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Clickable.PressStatus;
import org.simantics.g2d.element.handler.impl.AbstractClickable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * Tooltip support
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class TooltipParticipant extends BaseTooltipParticipant implements CompositionListener {

    private final ElementHoverListener listener = new ElementHoverListener();

    public TooltipParticipant() {
    }

    @Override
    protected void onDiagramSet(IDiagram newValue, IDiagram oldValue) {
        if (oldValue == newValue)
            return;
        if (oldValue != null) {
            for (IElement e : oldValue.getElements()) {
                removeElement(e);
            }
            oldValue.removeCompositionListener(this);
        }
        if (newValue != null) {
            for (IElement e : newValue.getElements()) {
                addElement(e);
            }
            newValue.addCompositionListener(this);
        }
    }

    @Override
    public void onElementAdded(IDiagram d, IElement e) {
        addElement(e);
    }

    @Override
    public void onElementRemoved(IDiagram d, IElement e) {
        removeElement(e);
    }

    private void addElement(IElement e) {
        e.addKeyHintListener(AbstractClickable.PRESS_STATUS_KEY, listener);
    }

    private void removeElement(IElement e) {
        e.removeKeyHintListener(AbstractClickable.PRESS_STATUS_KEY, listener);
    }



    class ElementHoverListener implements IHintListener {

        @Override
        public void hintChanged(IHintObservable sender, Key key,
                Object oldValue, Object newValue) {
            IElement element = (IElement)sender;
            PressStatus status = (PressStatus)newValue;
            if (status == PressStatus.HOVER) {
                showTooltipFor(element);
            } else {
                hideTooltip();
            }
            //System.out.println("ttp element changed " + element + " " + status);
        }

        @Override
        public void hintRemoved(IHintObservable sender, Key key, Object oldValue) {

        }
    }

}
