/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

import javax.swing.SwingUtilities;

import org.simantics.g2d.element.IElement;

/**
 * AWT based tooltip.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public abstract class AWTTooltipProvider implements TooltipProvider {

	private Frame frame;
	
	/**
	 * Construct popup UI.
	 * @param frame
	 * @param element
	 */
	public abstract void constructPopup(Frame frame,IElement element);
	
	@Override
	public void showTooltip(final IElement element, final int x, final int y) {
		SwingUtilities.invokeLater(new Runnable() {	
			@Override
			public void run() {
				if (frame != null) {
					frame.setVisible(false);
					frame.dispose();
					frame = null;
				}
				
				frame = new Frame();
				frame.setFocusableWindowState(false);
				frame.setUndecorated(true);
				
				constructPopup(frame, element);
				
				frame.pack();
				
				setTooltipPosition(x,y);
				
				frame.setVisible(true);
			}
		});
	}
	
	/**
	 * 
	 * @param x
	 * @param y
	 */
	private void setTooltipPosition(int x, int y) {

		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		for (GraphicsDevice gd : ge.getScreenDevices()) {
			Rectangle r = gd.getDefaultConfiguration().getBounds();
			if (r.contains(x, y)) {
				Rectangle ttr = new Rectangle(x, y, frame.getWidth(), frame.getHeight());
				//ttr.y -= frame.getHeight();
				ttr.y += 24;
				if (!r.contains(ttr)) {
					ttr.y = Math.max(r.y, ttr.y);
					ttr.y = Math.min(r.y + r.height, ttr.y + ttr.height) - ttr.height;
					ttr.x = Math.max(r.x, ttr.x);
					ttr.x = Math.min(r.x + r.width, ttr.x + ttr.width) - ttr.width;
				}
				frame.setLocation(ttr.x,ttr.y);
				return;
			}
		}
	}
	
	
	@Override
	public void hideTooltip(IElement element) {
		SwingUtilities.invokeLater(new Runnable() {	
			@Override
			public void run() {
				frame.setVisible(false);
				frame.dispose();
				frame = null;
				
			}
		});
	}
}
