/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.simantics.g2d.routing.Connection;
import org.simantics.g2d.routing.IRouterOld;
import org.simantics.g2d.routing.Obstacle;

public class RouterOld implements IRouterOld {

	Map<Connection, Path2D> connections = new HashMap<Connection, Path2D>();
	Set<Obstacle> obstacles = new HashSet<Obstacle>();
	boolean dirty = false;	

	@Override
	public void addObstacle(Obstacle obstacle) {
		obstacles.add(obstacle);
		dirty = true;
	}
	
	@Override
	public void removeObstacle(Obstacle obstacle) {
		obstacles.remove(obstacle);
		dirty = true;		
	}
	
	@Override
	public void addConnection(Connection connection) {
		connections.put(connection, null);
		dirty = true;
	}
	
	@Override
	public void removeConnection(Connection connection) {
		connections.remove(connection);
		dirty = true;		
	}	

	@Override
	public Path2D getPath(Connection connection) {
		if(dirty) {
			synchronized(this) {
				if(dirty) {
					long beginTime = System.nanoTime();
					update();
					long endTime = System.nanoTime();
					System.out.println((endTime-beginTime)*1e-6 + "ms");
					dirty = false;
				}
			}
		}
		return connections.get(connection);
	}

	private void update() {
		ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>(obstacles.size());
		for(Obstacle obs : obstacles) {
			Rectangle2D shape = obs.shape;
			rectangles.add(new Rectangle(
				shape.getMinX(),
				shape.getMinY(),
				shape.getMaxX(),
				shape.getMaxY()));
		}
		Connection[] carray = 
			connections.keySet().toArray(new Connection[connections.size()]);
		Arrays.sort(carray, new Comparator<Connection>() {

			@Override
			public int compare(Connection o1, Connection o2) {
				double l1 = o1.minLength();
				double l2 = o2.minLength();
				if(l1 < l2)
					return -1;
				if(l1 > l2)
					return 1;
				if(o1.routePath.length < o2.routePath.length)
					return -1;
				if(o1.routePath.length > o2.routePath.length)
					return 1;
				for(int i=0;i<o1.routePath.length;++i) {
					if(o1.routePath[i] < o2.routePath[i])
						return -1;
					if(o1.routePath[i] > o2.routePath[i])
						return 1;
				}
				return 0;
			}
			
		});
		//System.out.println("----------------------------------------------------------");
		ArrayList<Path2D> lines = new ArrayList<Path2D>(connections.size());		
		for(Connection c : carray) {
//			StaticRouter router = new StaticRouter(rectangles, lines);
//			Path2D path = router.route(c);
//			connections.put(c, path);
//			if(path != null)
//				lines.add(path);
		}
	}
}
