/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ImageUtils;
import org.simantics.utils.datastructures.cache.IFactory;

/**
 * Lazy initialization of bundle resources.
 * This class is capable of opening .svg .png .jpg etc files.
 * 
 * @See {@link ImageUtils}
 * @author Toni Kalajainen
 */
public class ImageBundleFactory extends ImageURLFactory implements IFactory<Image> {

	private static URL _resolveFilename(String filename)
	throws RuntimeException
	{
		IPath p = new Path(filename);
		String bundleId = p.segment(0);
		IPath bundlePath = p.removeFirstSegments(1);		
		Bundle bundle = Platform.getBundle(bundleId);
		URL url = FileLocator.find(bundle, bundlePath, null);
		if (url==null) 
	        throw new RuntimeException("File '" + bundlePath + "' not found in bundle '" + bundleId + "'");
		return url;
	}
	
	public ImageBundleFactory(String filename) 
	throws RuntimeException
	{
		super(_resolveFilename(filename));		
	}
	
}
