/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.canvas;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Toni Kalajainen
 */
public class CanvasClass {

    public static final Key KEY_CANVAS = new KeyOf(ICanvasContext.class);

    /**
     * Class that paints canvas as an element
     * Keys:
     *  {@link CanvasPainter}.KEY_CANVAS
     */
    public static final ElementClass CANVAS_CLASS =
        ElementClass.compile(
                Resizeable.UNCONSTRICTED,
                DefaultTransform.INSTANCE,
                CanvasPainter.INSTANCE
        );

    /**
     * Class that previews another diagram
     * Keys:
     * 	{@link DiagramHints}.KEY_DIAGRAM
     * 	{@link DiagramPainter}.KEY_VIEWPORT
     */
    public static final ElementClass DIAGRAM_CLASS =
        ElementClass.compile(
                Resizeable.UNCONSTRICTED,
                DefaultTransform.INSTANCE,
                DiagramPainter.INSTANCE
        );

    /**
     * Class that previews an element of another diagram.
     * Keys:
     * 	{@link ElementViewport}.KEY_ELEMENT
     */
    public static final ElementClass ELEMENT_VIEWPORT_CLASS =
        ElementClass.compile(
                FillColorImpl.UNSET,
                BorderColorImpl.UNSET,
                Resizeable.UNCONSTRICTED,
                DefaultTransform.INSTANCE,
                ElementViewport.INSTANCE,
                DiagramPainter.INSTANCE
        );

}
