/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Stateful;

/**
 * @author Toni Kalajainen
 */
public class ProxyEnabled implements Stateful {

    private static final long serialVersionUID = -8676152146283749592L;

    Stateful orig;
    IProxyProvider provider;

    public ProxyEnabled(IProxyProvider provider, Stateful orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public boolean isEnabled(IElement e) {
        return orig.isEnabled(e);
    }

    @Override
    public void setEnabled(IElement e, boolean enabled) {
        orig.setEnabled(e, enabled);
    }	
}
