/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;


import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.StaticSymbol;

/**
 * @author Tuukka Lehtonen
 */
public class StaticSymbolImageInitializer extends LifeCycle.Stub {

    private static final long serialVersionUID = -4694230472385444388L;

    public static final StaticSymbolImageInitializer INSTANCE = new StaticSymbolImageInitializer();

    private StaticSymbolImageInitializer() {
    }

    @Override
    public void onElementCreated(IElement e) {
        StaticSymbol ss = e.getElementClass().getSingleItem(StaticSymbol.class);
        e.setHint(ElementHints.KEY_IMAGE, ss.getImage());
    }

}