/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;

/**
 * @author Antti Villberg
 */
public interface ElementLayers extends ElementHandler {

    boolean isVisible(IElement e, ILayers layers);
    boolean isVisible(IElement e, ILayer layer);
    boolean isFocusable(IElement e, ILayers layers);
    boolean isFocusable(IElement e, ILayer layer);
    boolean setVisibility(IElement e, ILayer layer, boolean value);
    boolean setFocusability(IElement e, ILayer layer, boolean value);

}
