/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler.impl;

import java.util.Collection;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Validator.Issue;
import org.simantics.g2d.diagram.handler.Validator.Suggestion;

/**
 * Default implementation to diagram Issue
 * @See {@link Issue}
 * @author Toni Kalajainen
 */
public class DiagramIssue implements Issue {

	String msg;
	Suggestion[] suggestions;
	
	public DiagramIssue(String msg, Suggestion ... suggestions)
	{
		this.msg = msg;
		this.suggestions = suggestions;
	}

	@Override
	public void addSuggestions(IDiagram d, ICanvasContext ctx, Collection<Suggestion> suggestionList) {
		for (Suggestion s : suggestions)
			suggestionList.add(s);
	}

	@Override
	public String getMessage(IDiagram d, ICanvasContext ctx) {
		return msg;
	}
	
}
