/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas.impl;

import java.util.Collection;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.chassis.ITooltipProvider;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.IEventHandlerStack;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.utils.datastructures.context.IContextListener;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.disposable.IDisposeListener;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintStack;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * A dummy implementation of ICanvasContext that is immediately marked disposed.
 * Can be used in situations where the disposedness of an ICanvasContext is used
 * for (transient) life-cycle management.
 * 
 * @author Tuukka Lehtonen
 */
public class DisposedCanvasContext implements ICanvasContext {

    public static final DisposedCanvasContext INSTANCE = new DisposedCanvasContext();

    @Override
    public G2DParentNode getCanvasNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContentContext getContentContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IHintContext getDefaultHintContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IEventHandlerStack getEventHandlerStack() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IEventQueue getEventQueue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IHintStack getHintStack() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMouseCaptureContext getMouseCaptureContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMouseCursorContext getMouseCursorContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public G2DSceneGraph getSceneGraph() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IThreadWorkQueue getThreadAccess() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCanvasNode(G2DParentNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContentContext(IContentContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMouseCaptureContext(IMouseCaptureContext mctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMouseCursorContext(IMouseCursorContext mctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public void add(ICanvasParticipant item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addContextListener(IContextListener<ICanvasParticipant> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addContextListener(IThreadWorkQueue thread, IContextListener<ICanvasParticipant> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(ICanvasParticipant item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R> boolean containsItemByClass(Class<R> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R extends ICanvasParticipant> R getAtMostOneItemOfClass(Class<R> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R extends ICanvasParticipant> Collection<R> getItemsByClass(Class<R> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R extends ICanvasParticipant> R getSingleItem(Class<R> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(ICanvasParticipant item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeContextListener(IContextListener<ICanvasParticipant> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeContextListener(IThreadWorkQueue thread, IContextListener<ICanvasParticipant> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICanvasParticipant[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DisposeState getDisposeState() {
        return DisposeState.Disposed;
    }

    @Override
    public boolean isDisposed() {
        return true;
    }

    @Override
    public void removeDisposeListener(IDisposeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void safeDispose() {
        throw new UnsupportedOperationException();
    }

	@Override
	public ITooltipProvider getTooltipProvider() {
        throw new UnsupportedOperationException();
	}

	@Override
	public void setTooltipProvider(ITooltipProvider tooltipProvider) {
        throw new UnsupportedOperationException();
	}

}
