/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas;

import java.awt.Color;
import java.awt.Paint;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.canvas.impl.ToolMode;
import org.simantics.g2d.dnd.DragInteractor;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;
import org.simantics.utils.datastructures.hints.IHintContext.MouseSpecificKeyOf;
import org.simantics.utils.page.PageDesc;

/**
 * @author Toni Kalajainen
 */
public class Hints {

    public static final IToolMode POINTERTOOL              = new ToolMode("PointerTool");
    public static final IToolMode PANTOOL                  = new ToolMode("PanTool");
    public static final IToolMode CONNECTTOOL              = new ToolMode("ConnectTool");

    /** Selected Tool */
    public static final Key KEY_TOOL = new MouseSpecificKeyOf(0, IToolMode.class);

    /** Transform that converts point from canvas to control */
    public static final Key KEY_CANVAS_TRANSFORM = new KeyOf(AffineTransform.class, "CANVAS_TRANSFORM");

    /**
     * Rendering surface boundaries.
     * 
     * @see CanvasBoundsParticipant
     */
    public static final Key KEY_CONTROL_BOUNDS = new KeyOf(Rectangle2D.class, "CONTROL_BOUNDS");

    /**
     * Visible canvas boundaries.
     * 
     * @see CanvasBoundsParticipant
     */
    public static final Key KEY_CANVAS_BOUNDS = new KeyOf(Rectangle2D.class, "CANVAS_BOUNDS");

    /** Background color - BackgroundPainter */
    public static final Key KEY_BACKGROUND_COLOR = new KeyOf(Color.class, "BACKGROUND_COLOR");
    public static final Key KEY_BACKGROUND_PAINT = new KeyOf(Paint.class, "BACKGROUND_PAINT");

    /** The color of the grid */
    public static final Key KEY_GRID_COLOR = new KeyOf(Color.class, "GRID_COLOR");

    /** Parent canvas (in hierarchical canvas structure) */
    public static final Key KEY_SUPER_CANVAS = new KeyOf(ICanvasContext.class, "SUPER_CANVAS");

    /** Description of a page size for canvas or diagram. */
    public static final Key KEY_PAGE_DESC = new KeyOf(PageDesc.class, "PAGE_DESC");

    /** Indicate whether or not to display page bounds. */
    public static final Key KEY_DISPLAY_PAGE = new KeyOf(Boolean.class, "DISPLAY_PAGE");

    /** Indicate whether or not to display page margins. */
    public static final Key KEY_DISPLAY_MARGINS = new KeyOf(Boolean.class, "DISPLAY_MARGINS");

    /**
     * A hint for disabling painting of the diagram the hint is associated with.
     * Can also be used with a canvas context to signal that the nothing should
     * be painted on the canvas.
     */
    public static final Key KEY_DISABLE_PAINTING = new KeyOf(Boolean.class, "DISABLE_PAINTING");

    /**
     * Used by {@link DragInteractor} during its {@link DragGestureRecognizer}
     * initialization to get the allowed DND actions by the drag source. See
     * {@link DnDConstants} for the values of which this value can ORed from.
     */
    public static final Key KEY_ALLOWED_DRAG_ACTIONS = new KeyOf(Integer.class, "ALLOWED_DRAG_ACTIONS");

    /**
     * Set to true when the canvas is rendering to a printer
     */
    public static final Key KEY_PRINT = new KeyOf(Boolean.class, "PRINTING");

    /**
     * Set this hint to <code>true</code> to prevent any modifications from
     * being made to the diagram model by the diagram loading logic. Using this
     * may be necessary for printing.
     */
    public static final Key KEY_DISABLE_GRAPH_MODIFICATIONS = new KeyOf(Boolean.class, "DISABLE_GRAPH_MODIFICATIONS");

    private interface Dirty {}

    /**
     * The existence of this hint generically used to signal that something in
     * the related observable has been modified that may cause it to be out of
     * sync with its visual appearance which is represented by a scene graph.
     * 
     * @see #VALUE_DIRTY
     * 
     * @author Tuukka Lehtonen
     */
    public static final Key KEY_DIRTY = new KeyOf(Dirty.class, "DIRTY");

    /**
     * The value to use for indicating that the scene graph of an observable may be
     * dirty and needs to be updated.
     * 
     * @see KEY_DIRTY
     */
    public static final Dirty VALUE_SG_DIRTY = new Dirty() {
        @Override
        public String toString() { return "SG_DIRTY"; }
    };

    /**
     * The value to use for indicating that the scene graph of an observable
     * should be updated after a delay. The delay is left up to the party
     * tracking this hint value.
     * 
     * @see KEY_DIRTY
     */
    public static final Dirty VALUE_SG_DELAYED_UPDATE = new Dirty() {
        @Override
        public String toString() { return "SG_DELAYED_UPDATE"; }
    };

    /**
     * The value to use for indicating that the z-order of diagram elements may
     * have changed.
     * 
     * @see KEY_DIRTY
     */
    public static final Dirty VALUE_Z_ORDER_CHANGED = new Dirty() {
        @Override
        public String toString() { return "Z_ORDER_CHANGED"; }
    };

}
