/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.filesystem.services.internal.sizetracker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.simantics.filesystem.services.internal.sizetracker.DirectorySizeServiceImpl;
import org.simantics.filesystem.services.internal.sizetracker.SizeChangeEventImpl;
import org.simantics.filesystem.services.sizetracker.SizeChangeEvent;
import org.simantics.filesystem.services.sizetracker.SizeTracker;
import org.simantics.utils.datastructures.file.DirectorySizeTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTrackerImpl
implements SizeTracker {
    private Logger logger = LoggerFactory.getLogger(SizeTrackerImpl.class);
    private Path path;
    private DirectorySizeServiceImpl service;
    private DirectorySizeTracker tracker;
    private CopyOnWriteArrayList<Consumer<SizeChangeEvent>> listeners = new CopyOnWriteArrayList();
    private volatile long oldSize = 0L;
    private LongConsumer theListener = newSize -> {
        long os = this.oldSize;
        this.oldSize = newSize;
        this.fireSizeChange(os, newSize);
    };

    public SizeTrackerImpl(DirectorySizeServiceImpl service, Path path) throws IOException {
        this.service = service;
        this.path = path;
        this.tracker = DirectorySizeTracker.startTracker((LongConsumer)this.theListener);
    }

    public SizeTrackerImpl start() throws IOException {
        new Thread(() -> {
            try {
                SizeTrackerImpl sizeTrackerImpl = this;
                synchronized (sizeTrackerImpl) {
                    if (this.tracker != null) {
                        this.tracker.track(this.path);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to start tracking size of directory " + this.path, (Throwable)e);
            }
        }, "SizeTrackerStarter").start();
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.tracker == null) {
            return;
        }
        this.tracker.close();
        this.tracker = null;
        this.service.removeTracker(this.path);
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public long size() {
        return this.oldSize;
    }

    @Override
    public void addListener(Consumer<SizeChangeEvent> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Consumer<SizeChangeEvent> listener) {
        this.listeners.remove(listener);
    }

    private void fireSizeChange(long oldSize, long newSize) {
        SizeChangeEventImpl e = new SizeChangeEventImpl(this.path, oldSize, newSize);
        this.listeners.forEach((Consumer<Consumer<SizeChangeEvent>>)((Consumer<Consumer>)c -> c.accept(e)));
    }
}

