package org.simantics.filesystem.services.internal.sizetracker;

import java.nio.file.Path;

import org.simantics.filesystem.services.sizetracker.SizeChangeEvent;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class SizeChangeEventImpl implements SizeChangeEvent {

	private final Path path;
	private final long oldSize;
	private final long newSize;

	public SizeChangeEventImpl(Path path, long oldSize, long newSize) {
		this.path = path;
		this.oldSize = oldSize;
		this.newSize = newSize;
	}

	@Override
	public Path path() {
		return path;
	}

	@Override
	public long newSize() {
		return newSize;
	}

	@Override
	public long oldSize() {
		return oldSize;
	}

}