package org.simantics.fileimport;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.fileimport.dropins.FileImportDropins;

public class Activator implements BundleActivator {

    private static BundleContext context;
	
    private static Path modelsFolder = null;
	private static Path dropinsFolder = null;

	static BundleContext getContext() {
		return context;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext bundleContext) throws Exception {
		Activator.context = bundleContext;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext bundleContext) throws Exception {
		Activator.context = null;
		FileImportDropins.unwatchDropinsFolder();
	}
	
	public static Path getDropinsFolder() throws IOException {
	    if (dropinsFolder == null) {
	        IPath state = Platform.getStateLocation(context.getBundle());
	        dropinsFolder = Paths.get(state.append("dropins").toOSString());
	        Files.createDirectories(dropinsFolder);
	    }
	    return dropinsFolder;
	}

    public static Path getModelsFolder() throws IOException {
        if (modelsFolder == null) {
            IPath state = Platform.getStateLocation(context.getBundle());
            modelsFolder = Paths.get(state.append("models").toOSString());
            Files.createDirectories(modelsFolder);
        }
        return modelsFolder;
    }

}
