/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.fastlz.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

import org.simantics.compressions.impl.DecompressingInputStream;
import org.simantics.fastlz.FastLZJava;

/**
 * @author Tuukka Lehtonen
 */
public class FastLZJavaInputStream extends DecompressingInputStream {

    public FastLZJavaInputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public FastLZJavaInputStream(FileInputStream stream) {
        super(stream);
    }

    public FastLZJavaInputStream(InputStream stream) {
        super(stream);
    }

    public FastLZJavaInputStream(InputStream stream, ReadableByteChannel channel) {
        super(stream, channel);
    }

    @Override
    protected ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocate(capacity);
    }
    
    @Override
    public void decompress(ByteBuffer compressed, int compressedOffset, int compressedSize, ByteBuffer uncompressed,
            int uncompressedOffset, int uncompressedSize) throws IOException {
        int decompressed = FastLZJava.decompress(compressed.array(), 0,
                compressedSize, uncompressed.array(), 0, uncompressedSize);
        if (decompressed != uncompressedSize)
            throw new IOException("decompressed " + decompressed + " bytes when " + uncompressedSize + " bytes were expected.");
    }

}
