/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.fastlz.impl;

import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.bundle.Activator;


/**
 * Private helpers related to loading and initializing the native parts of the
 * FastLZ library.
 * 
 * @author Tuukka Lehtonen
 */
public class FastLZConfig {

    /**
	 * A simple private indicator for class {@link FastLZ} to know whether to
	 * attempt static initialization or not.
	 * 
	 * <p>
	 * By default, FastLZ shall attempt static initialization. When initialized
	 * as a bundle, initialization will not be handled statically but through
	 * the bundle activator.
	 * 
	 * @see Activator
	 */
    public static boolean attemptStaticInitialization = true;

}
