/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.manager;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.RequestProcessor;
import org.simantics.export.core.error.ExportException;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;

public class TransferableGraphWriter {
    public final File file;
    public final String format;
    public final int version;

    public TransferableGraphWriter(File file, String format, int version) {
        this.file = file;
        this.format = format;
        this.version = version;
    }

    public void writeFile(Binding tgBinding, Object tg) throws ExportException {
        try {
            Variant variant = new Variant(tgBinding, tg);
            DataContainer dataContainer = new DataContainer(this.format, this.version, variant);
            DataContainers.writeFile((File)this.file, (DataContainer)dataContainer);
        }
        catch (IOException e) {
            throw new ExportException("I/O Error occured: " + e.getMessage());
        }
    }

    public void writeFile(RequestProcessor session, TransferableGraphSource source) throws ExportException {
        this.writeFile(session, source, new TreeMap<String, Variant>());
    }

    public void writeFile(RequestProcessor session, TransferableGraphSource source, TreeMap<String, Variant> metadata) throws ExportException {
        try {
            TransferableGraphs.writeTransferableGraph((RequestProcessor)session, (String)this.format, (int)this.version, metadata, (TransferableGraphSource)source, (File)this.file);
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }
}

