package org.simantics.export.core.intf;

import java.util.Collection;
import java.util.Map;

import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;

public interface ContentTypeAction {

	/**
	 * Read labels for a collection of contents
	 * 
	 * @param ctx 
	 * @param contents
	 * @return labels
	 * @throws ExportException if failed to get a label
	 */
	Map<String, String> getLabels( ExportContext ctx, Collection<String> contents ) throws ExportException;
	
}
