/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.excel.Activator;
import org.simantics.excel.ExcelException;
import org.simantics.excel.ExecEnvironment;
import org.simantics.utils.FileUtils;

public class Excel {
    private static Excel instance;
    private static final Charset ascii;
    private static final String REQUIRED_FILES_DESCRIPTOR_FILE = "required_files.txt";
    private static final String[] DEFAULT_REQUIRED_FILES;
    private static File extractDir;
    private static String[] requiredFiles;
    private static boolean needExtraction;
    public static final String EXCEL_FOLDER = "Excel";
    final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    static {
        ascii = Charset.forName("US-ASCII");
        DEFAULT_REQUIRED_FILES = new String[]{"SimanticsExcel.dll", "SimanticsExcel_64.dll"};
        extractDir = null;
        requiredFiles = null;
        needExtraction = false;
    }

    public static Excel getInstance(PrintStream out) throws ExcelException {
        if (instance == null) {
            if (Platform.inDevelopmentMode()) {
                Bundle b = Activator.getDefault().getBundle();
                URL url = FileLocator.find((Bundle)b, (IPath)new Path(""), null);
                try {
                    extractDir = new File(URLDecoder.decode(FileLocator.toFileURL((URL)url).getPath(), "UTF-8"));
                }
                catch (IOException e) {
                    e.printStackTrace(out);
                    throw new ExcelException(e);
                }
            }
            try {
                Excel.start(out);
            }
            catch (IOException e) {
                e.printStackTrace(out);
                throw new ExcelException(e);
            }
            catch (Throwable t) {
                t.printStackTrace(out);
                throw new ExcelException(t);
            }
            instance = new Excel(out);
        }
        return instance;
    }

    public File getDirectory() throws IOException {
        Bundle b = Platform.getBundle((String)"org.simantics.excel");
        if (b == null) {
            throw new AssertionError((Object)"Could not resolve bundle 'org.simantics.excel' although were running in its fragment. Should not happen.");
        }
        BundleContext context = b.getBundleContext();
        if (context == null) {
            throw new AssertionError((Object)("Could not get bundle context for bundle 'org.simantics.excel'. Bundle state is " + b.getState() + "."));
        }
        File extractDir = context.getDataFile("");
        if (extractDir == null) {
            throw new IOException("Bundle 'org.simantics.excel context has no file system support. Cannot extract server executables.");
        }
        if (!extractDir.exists() && !extractDir.mkdir()) {
            throw new IOException("Could not create directory '" + extractDir.getCanonicalPath() + "' for storing Balas solver data.");
        }
        return extractDir;
    }

    public String getContainer() {
        return UUID.randomUUID().toString();
    }

    public String getFile(String name) {
        try {
            return String.valueOf(this.getDirectory().getAbsolutePath()) + "\\" + name;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Excel(PrintStream out) throws ExcelException {
        try {
            Future<?> future = this.init_(extractDir + File.separator);
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ExcelException(e);
        }
        catch (ExecutionException e) {
            throw new ExcelException(e);
        }
        catch (TimeoutException e) {
            throw new ExcelException(e);
        }
    }

    public static IPath getAbsolutePath(String inBundle, String fullpath) {
        Bundle b = Platform.getBundle((String)inBundle);
        if (b == null) {
            return null;
        }
        return Excel.getAbsolutePath(b, fullpath);
    }

    public static IPath getAbsolutePath(Bundle inBundle, String fullpath) {
        Path path = new Path(fullpath);
        URL u = FileLocator.find((Bundle)inBundle, (IPath)path, null);
        if (u != null) {
            try {
                u = FileLocator.resolve((URL)u);
                if ("file".equals(u.getProtocol())) {
                    Path p = new Path(new File(u.getFile()).getAbsolutePath());
                    return p;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static IPath getAbsolutePath(String fullpath) {
        Bundle b = Platform.getBundle((String)"org.simantics.excel");
        if (b == null) {
            return null;
        }
        Path path = new Path(fullpath);
        URL u = FileLocator.find((Bundle)b, (IPath)path, null);
        if (u != null) {
            try {
                u = FileLocator.resolve((URL)u);
                if ("file".equals(u.getProtocol())) {
                    Path p = new Path(new File(u.getFile()).getAbsolutePath());
                    return p;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    static String[] getRequiredFiles() {
        if (requiredFiles != null) {
            return requiredFiles;
        }
        Bundle b = Platform.getBundle((String)"org.simantics.excel");
        if (b == null) {
            return null;
        }
        ArrayList<Enumeration> enu = new ArrayList<Enumeration>();
        enu.add(b.findEntries("/", "*.dll", true));
        ArrayList<String> filez = new ArrayList<String>();
        for (Enumeration e : enu) {
            while (e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                filez.add(url.getFile());
            }
        }
        requiredFiles = filez.toArray(new String[filez.size()]);
        return requiredFiles;
    }

    private static File extractFiles() throws IOException {
        Bundle b = Platform.getBundle((String)"org.simantics.excel");
        if (b == null) {
            throw new AssertionError((Object)"Could not resolve bundle 'org.simantics.excel' although were running in it. Should not happen.");
        }
        String[] stringArray = Excel.getRequiredFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            URL url = FileLocator.find((Bundle)b, (IPath)new Path(file), null);
            File fzz = new File(extractDir, file);
            Path path = new Path(fzz.getAbsolutePath());
            path.removeLastSegments(1).toFile().mkdirs();
            FileUtils.copyResource((URL)url, (File)fzz, (boolean)false);
            ++n2;
        }
        return extractDir;
    }

    public static void start(PrintStream out) throws IOException {
        File test;
        Bundle b = Platform.getBundle((String)"org.simantics.excel");
        if (b == null) {
            throw new AssertionError((Object)"Could not resolve bundle 'org.simantics.excel' although were running in its fragment. Should not happen.");
        }
        BundleContext context = b.getBundleContext();
        if (context == null) {
            throw new AssertionError((Object)("Could not get bundle context for bundle 'org.simantics.excel'. Bundle state is " + b.getState() + "."));
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        extractDir = new File(workspaceRoot.getLocation().toFile(), EXCEL_FOLDER);
        if (!extractDir.exists() && !extractDir.mkdir()) {
            throw new IOException("Could not create directory '" + extractDir.getCanonicalPath() + "' for storing Balas solver data.");
        }
        String asd = "";
        ExecEnvironment env = ExecEnvironment.calculate();
        if (env.os == ExecEnvironment.OSType.WINDOWS) {
            if (env.arch == ExecEnvironment.ARCHType.X86) {
                asd = extractDir + "\\SimanticsExcel.dll";
            } else if (env.arch == ExecEnvironment.ARCHType.X86_64) {
                asd = extractDir + "\\SimanticsExcel_64.dll";
            }
        }
        if ((test = new File(asd)).exists()) {
            needExtraction = false;
            return;
        }
        needExtraction = true;
        if (needExtraction) {
            extractDir = Excel.extractFiles();
        } else {
            out.println("needExtraction=false");
        }
    }

    private native int init();

    private native String open(String var1, String var2);

    private native String getModifications(int var1);

    private native int setDouble(int var1, int var2, int var3, double var4);

    private native int setString(int var1, int var2, int var3, String var4);

    private native int setName(int var1, int var2, int var3, String var4);

    private native int setVisible(int var1, boolean var2);

    private native int close(int var1);

    public Future<?> init_(String path) {
        return this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                String asd = "";
                ExecEnvironment env = ExecEnvironment.calculate();
                if (env.os == ExecEnvironment.OSType.WINDOWS) {
                    if (env.arch == ExecEnvironment.ARCHType.X86) {
                        asd = extractDir + "\\SimanticsExcel.dll";
                    } else if (env.arch == ExecEnvironment.ARCHType.X86_64) {
                        asd = extractDir + "\\SimanticsExcel_64.dll";
                    }
                }
                System.load(asd);
                Excel.this.init();
            }
        });
    }

    public String open_(final String fileName, final String sheetName) {
        try {
            return this.scheduler.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return Excel.this.open(fileName, sheetName);
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public int setDouble_(final int handle, final int row, final int column, final double value) {
        try {
            return this.scheduler.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Excel.this.setDouble(handle, row, column, value);
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setString_(final int handle, final int row, final int column, final String value) {
        try {
            return this.scheduler.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Excel.this.setString(handle, row, column, value);
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getModifications_(final int handle) {
        try {
            return this.scheduler.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return Excel.this.getModifications(handle);
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public int setName_(final int handle, final int row, final int column, final String value) {
        try {
            return this.scheduler.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Excel.this.setName(handle, row, column, value);
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setVisible_(final int handle, final Boolean value) {
        try {
            return this.scheduler.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Excel.this.setVisible(handle, value);
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int close_(final int handle) {
        try {
            return this.scheduler.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int ret = Excel.this.close(handle);
                    return ret;
                }
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

