/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.event.Activator;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.util.EventUtils;
import org.simantics.event.view.handler.ClaimAction;
import org.simantics.event.view.handler.CorrectMilestoneLabelsAction;
import org.simantics.event.view.handler.DenyAction;
import org.simantics.event.view.handler.TagAction;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.workbench.action.PerformDefaultAction;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class MenuActions
extends DynamicMenuContribution {
    private static final String VG_EXPERIMENTS = "experiments";

    protected Object[] getSelectedObjects() {
        ISelection sel = this.getSelection();
        List resources = ISelectionUtils.getPossibleKeys((Object)sel, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        return resources.toArray();
    }

    List<Resource> toResources(Object[] array) {
        Resource[] a = new Resource[array.length];
        int i = 0;
        while (i < array.length) {
            a[i] = (Resource)array[i];
            ++i;
        }
        return Arrays.asList(a);
    }

    protected IAction[] getActions(ReadGraph graph, Object[] selection) throws DatabaseException {
        Resource eventSource;
        Resource eventLog;
        if (selection.length == 0) {
            return new IAction[0];
        }
        List<Resource> input = this.toResources(selection);
        if (input.isEmpty()) {
            return new IAction[0];
        }
        boolean logs = false;
        boolean events = false;
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        int hiddenCount = 0;
        int milestoneCount = 0;
        int hasSourceCount = 0;
        for (Resource r : input) {
            logs |= graph.isInstanceOf(r, EVENT.EventLog);
            events |= graph.isInstanceOf(r, EVENT.Event);
            if (graph.hasStatement(r, EVENT.Hidden)) {
                ++hiddenCount;
            }
            if (graph.hasStatement(r, EVENT.Milestone)) {
                ++milestoneCount;
            }
            if (!graph.hasStatement(r, EVENT.Event_source)) continue;
            ++hasSourceCount;
        }
        boolean allHidden = hiddenCount == selection.length;
        boolean allMilestones = milestoneCount == selection.length;
        Resource event = null;
        String eventSourceName = null;
        if (input.size() == 1) {
            event = input.get(0);
            if (hasSourceCount == 1) {
                eventSourceName = (String)graph.getPossibleRelatedValue(event, EVENT.Event_sourceName, (Binding)Bindings.STRING);
            }
        }
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (eventSourceName != null && !eventSourceName.isEmpty()) {
            actions.add(this.toClipboardAction(eventSourceName, eventSourceName));
        }
        if (!allHidden) {
            actions.add(this.hideAction(input));
        }
        if (hiddenCount > 0 || allHidden) {
            actions.add(this.unhideAction(input));
        }
        if (!logs && !allMilestones) {
            actions.add(this.markMilestoneAction(input));
        }
        if (!logs && (milestoneCount > 0 || allMilestones)) {
            eventLog = (Resource)graph.syncRequest((Read)new PossibleTypedParent(input.get(0), EVENT.EventLog));
            actions.add(this.unmarkMilestoneAction(eventLog, input));
        }
        if (!logs && events && event != null && (eventLog = (Resource)graph.syncRequest((Read)new PossibleTypedParent(event, EVENT.EventLog))) != null) {
            boolean isBaseline = graph.hasStatement(eventLog, EVENT.EventLog_HasBaselineEvent, event);
            if (isBaseline && allMilestones) {
                actions.add(this.removeBaseline(Collections.singletonList(eventLog)));
            } else {
                actions.add(this.setBaseline(eventLog, event));
            }
        }
        if (logs && !events) {
            actions.add(this.removeBaseline(input));
        }
        if (event != null && hasSourceCount == 1 && (eventSource = graph.getPossibleObject(event, EVENT.Event_source)) != null) {
            actions.add(this.performDefaultAction(eventSource, null));
        }
        return actions.toArray(new IAction[actions.size()]);
    }

    private IAction toClipboardAction(String label, String text) {
        return new ToClipboardAction(label, text);
    }

    private IAction markMilestoneAction(List<Resource> input) {
        return this.tagAction("Mark as Milestone", Activator.MARK_MILESTONE_ICON, "http://www.simantics.org/Event-1.2/Milestone", true, input);
    }

    private IAction unmarkMilestoneAction(Resource eventLog, List<Resource> input) {
        return new UnmarkMilestone(VG_EXPERIMENTS, eventLog, input);
    }

    private IAction unhideAction(List<Resource> input) {
        return this.tagAction("Unhide", Activator.UNHIDE_ICON, "http://www.simantics.org/Event-1.2/Hidden", false, input);
    }

    private IAction hideAction(List<Resource> input) {
        return this.contentChangingTagAction("Hide", Activator.HIDE_ICON, "http://www.simantics.org/Event-1.2/Hidden", true, input);
    }

    private IAction tagAction(String label, ImageDescriptor image, String tagURI, boolean tag, List<Resource> input) {
        return new TagAction(label, image, VG_EXPERIMENTS, tagURI, tag, input);
    }

    private IAction contentChangingTagAction(String label, ImageDescriptor image, String tagURI, boolean tag, List<Resource> input) {
        return new ContentChangingTagAction(label, image, VG_EXPERIMENTS, tagURI, tag, input);
    }

    private IAction setBaseline(Resource eventLog, Resource event) {
        return new SetBaseline(VG_EXPERIMENTS, eventLog, event);
    }

    private IAction removeBaseline(List<Resource> logs) {
        return new DenyAction("Remove Baseline", Activator.REMOVE_BASELINE_ICON, VG_EXPERIMENTS, "http://www.simantics.org/Event-1.2/EventLog/HasBaselineEvent", logs);
    }

    private IAction performDefaultAction(Resource input, String sourceName) {
        String title = "Show Event Source";
        if (sourceName != null) {
            title = String.valueOf(title) + " (" + sourceName + ")";
        }
        return new PerformDefaultAction(title, null, (Object)input);
    }

    private static class ContentChangingTagAction
    extends TagAction {
        public ContentChangingTagAction(String label, ImageDescriptor image, String virtualGraphId, String tagURI, boolean tag, List<Resource> input) {
            super(label, image, virtualGraphId, tagURI, tag, input);
        }

        @Override
        public void postTagWrite(WriteGraph graph) throws DatabaseException {
            EventUtils.bumpModificationCounter(graph, this.resources);
        }
    }

    private static class SetBaseline
    extends ClaimAction {
        public SetBaseline(String virtualGraphId, Resource subject, Resource object) {
            super("Set Baseline", Activator.SET_BASELINE_ICON, virtualGraphId, subject, "http://www.simantics.org/Event-1.2/EventLog/HasBaselineEvent", object);
        }

        @Override
        public void claim(WriteGraph graph) throws DatabaseException {
            super.claim(graph);
            EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
            if (!graph.hasStatement(this.object, EVENT.Milestone)) {
                graph.claim(this.object, EVENT.Milestone, this.object);
                CorrectMilestoneLabelsAction.correctMilestoneLabels(graph, graph.getProvider(), Collections.singleton(this.object));
            }
        }
    }

    private static class ToClipboardAction
    extends Action {
        private String text;

        public ToClipboardAction(String label, String text) {
            super(label, Activator.CLIPBOARD_ICON);
            this.text = text;
        }

        public void run() {
            IStatusLineManager status;
            Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
            clipboard.setContents(new Object[]{this.text}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
            IWorkbenchPart part = WorkbenchUtils.getActiveWorkbenchPart();
            if (part != null && (status = WorkbenchUtils.getStatusLine((IWorkbenchPart)part)) != null) {
                status.setErrorMessage(null);
                status.setMessage("Copied '" + this.text + "' to clipboard");
            }
        }
    }

    private static class UnmarkMilestone
    extends TagAction {
        private final Resource eventLog;
        private final List<Resource> events;

        public UnmarkMilestone(String virtualGraphId, Resource eventLog, List<Resource> events) {
            super("Unmark Milestone", Activator.UNMARK_MILESTONE_ICON, virtualGraphId, "http://www.simantics.org/Event-1.2/Milestone", false, events);
            this.eventLog = eventLog;
            this.events = events;
        }

        @Override
        public void postTagWrite(WriteGraph graph) throws DatabaseException {
            EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
            Resource baselineEvent = graph.getPossibleObject(this.eventLog, EVENT.EventLog_HasBaselineEvent);
            if (baselineEvent != null && this.events.contains(baselineEvent)) {
                graph.deny(this.eventLog, EVENT.EventLog_HasBaselineEvent);
            }
        }
    }
}

