/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

/**
 * Web Browser
 * Visiblity of controls (back, forward, url, ...) can be configured with the BrowserInput
 * 
 * @author Marko Luukkainen <Marko.Luukkainen@vtt.fi>
 *
 */
public class Browser extends EditorPart {

    public static final String ID = "org.simantics.editors.browser";

    org.eclipse.swt.browser.Browser browser;
    ToolBar toolbar;
    LocalResourceManager resourceManager;

    private final ImageDescriptor BACK_IMAGE = Activator.imageDescriptorFromPlugin(Activator.PLUGIN_ID, "icons/browser/arrow_left.png");
    private final ImageDescriptor FORWARD_IMAGE = Activator.imageDescriptorFromPlugin(Activator.PLUGIN_ID, "icons/browser/arrow_right.png");
    private final ImageDescriptor STOP_IMAGE = Activator.imageDescriptorFromPlugin(Activator.PLUGIN_ID, "icons/browser/stop.png");
    private final ImageDescriptor REFRESH_IMAGE = Activator.imageDescriptorFromPlugin(Activator.PLUGIN_ID, "icons/browser/arrow_rotate_clockwise.png");

    private Shell fsShell;

    public Browser() {

    }

    @Override
    public void doSave(IProgressMonitor monitor) {

    }

    @Override
    public void doSaveAs() {

    }

    @Override
    public void init(IEditorSite site, IEditorInput input)
    throws PartInitException {
        if (!(input instanceof BrowserInput))
            throw new PartInitException("Input must be instance of BrowserInput");
        setSite(site);
        setInput(input);

        // Set initial part name according to the name given by IEditorInput
        setPartName(getEditorInput().getName());
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void createPartControl(Composite parent) {
        resourceManager = new LocalResourceManager(JFaceResources.getResources(), parent);
        Image backImage = resourceManager.createImage(BACK_IMAGE);
        Image forwardImage = resourceManager.createImage(FORWARD_IMAGE);
        Image stopImage = resourceManager.createImage(STOP_IMAGE);
        Image refreshImage = resourceManager.createImage(REFRESH_IMAGE);

        // http://dev.eclipse.org/viewcvs/index.cgi/%7Echeckout%7E/org.eclipse.swt.snippets/src/org/eclipse/swt/snippets/Snippet128.java
        BrowserInput input = (BrowserInput)getEditorInput();
        boolean fullscreen = input.isFullscreen();
        if (fullscreen) {
            fsShell = new Shell(parent.getDisplay());

            fsShell.setLayout(new GridLayout(1,false));
            fsShell.setLayout(new FillLayout());
            parent = new Composite(fsShell,SWT.NONE);
            fsShell.open();
            fsShell.setFullScreen(true);
            parent.setLayout(new FillLayout());
        }

        String url = input.getUrl().toString();
        boolean showControls = input.isShowControls();
        if (showControls) {
            Composite composite = new Composite(parent, SWT.NONE);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout(gridLayout);
            toolbar = new ToolBar(composite, SWT.NONE);
            ToolItem itemBack = new ToolItem(toolbar, SWT.PUSH);
            itemBack.setText("Back");
            itemBack.setImage(backImage);
            ToolItem itemForward = new ToolItem(toolbar, SWT.PUSH);
            itemForward.setText("Forward");
            itemForward.setImage(forwardImage);
            ToolItem itemStop = new ToolItem(toolbar, SWT.PUSH);
            itemStop.setText("Stop");
            itemStop.setImage(stopImage);
            ToolItem itemRefresh = new ToolItem(toolbar, SWT.PUSH);
            itemRefresh.setText("Refresh");
            itemRefresh.setImage(refreshImage);
            // ToolItem itemGo = new ToolItem(toolbar, SWT.PUSH);
            // itemGo.setText("Go");

            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            data.horizontalAlignment = SWT.FILL;
            data.verticalAlignment = SWT.CENTER;
            data.horizontalSpan = 3;
            toolbar.setLayoutData(data);

            Label labelAddress = new Label(composite, SWT.NONE);
            labelAddress.setText("Address");

            final Text location = new Text(composite, SWT.BORDER);
            data = new GridData();
            data.horizontalAlignment = GridData.FILL;
            data.horizontalSpan = 2;
            data.grabExcessHorizontalSpace = true;
            location.setLayoutData(data);

            browser = new org.eclipse.swt.browser.Browser(composite, input.getBrowserStyle());

            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = SWT.FILL;
            data.verticalAlignment = SWT.FILL;
            data.horizontalSpan = 3;
            browser.setLayoutData(data);

            final Label statusl = new Label(composite, SWT.NONE);
            data = new GridData(GridData.FILL_HORIZONTAL);
            data.horizontalSpan = 2;
            statusl.setLayoutData(data);

            final ProgressBar progressBar = new ProgressBar(composite, SWT.NONE);
            data = new GridData();
            data.horizontalAlignment = GridData.END;
            progressBar.setLayoutData(data);

            browser.addProgressListener(new ProgressListener() {
                @Override
                public void changed(ProgressEvent event) {
                    if (event.total == 0)
                        return;
                    int ratio = event.current * 100 / event.total;
                    progressBar.setSelection(ratio);
                }

                @Override
                public void completed(ProgressEvent event) {
                    progressBar.setSelection(0);
                }
            });
            browser.addStatusTextListener(new StatusTextListener() {
                @Override
                public void changed(StatusTextEvent event) {
                    statusl.setText(event.text);
                }
            });
            browser.addLocationListener(new LocationListener() {
                @Override
                public void changed(LocationEvent event) {
                    if (event.top)
                        location.setText(event.location);
                    scheduleSetPartName();
                }

                @Override
                public void changing(LocationEvent event) {
                }
            });

            Listener listener = new Listener() {
                @Override
                public void handleEvent(Event event) {
                    ToolItem item = (ToolItem) event.widget;
                    String string = item.getText();
                    if (string.equals("Back"))
                        browser.back();
                    else if (string.equals("Forward"))
                        browser.forward();
                    else if (string.equals("Stop"))
                        browser.stop();
                    else if (string.equals("Refresh"))
                        browser.refresh();
                    // else if (string.equals("Go"))
                    // browser.setUrl(location.getText());
                }
            };

            itemBack.addListener(SWT.Selection, listener);
            itemForward.addListener(SWT.Selection, listener);
            itemStop.addListener(SWT.Selection, listener);
            itemRefresh.addListener(SWT.Selection, listener);
        } else { // !showControls
            browser = new org.eclipse.swt.browser.Browser(parent, input.getBrowserStyle());
            browser.addLocationListener(new LocationListener() {
                @Override
                public void changed(LocationEvent event) {
                    scheduleSetPartName();
                }
                @Override
                public void changing(LocationEvent event) {
                }
            });
        }

        browser.setUrl(url);

        if (fullscreen) {
            fsShell.layout(true, true);
        }
    }

    protected void scheduleSetPartName() {
        browser.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                if (browser.isDisposed())
                    return;
                String name = getEditorInput().getName();
                setPartName(name);
            }
        });
    }

    @Override
    public void setFocus() {
        browser.setFocus();
    }

    @Override
    public void dispose() {
        if (fsShell != null)
            fsShell.dispose();
        super.dispose();
    }

    public org.eclipse.swt.browser.Browser getBrowser() {
        return browser;
    }

}
