/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class TextInputDialog
extends Dialog {
    private Map<IInputValidator, String> validators = new HashMap<IInputValidator, String>();

    protected TextInputDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean validate(Text text, IInputValidator validator) {
        String err = null;
        if (validator != null) {
            err = validator.isValid(text.getText());
        }
        this.validators.put(validator, err);
        Button button = this.getButton(0);
        if (button != null) {
            boolean valid = true;
            for (String s : this.validators.values()) {
                if (s == null) continue;
                valid = false;
            }
            button.setEnabled(valid);
        }
        if (err != null) {
            text.setForeground(Display.getCurrent().getSystemColor(3));
            text.setToolTipText(err);
            return false;
        }
        text.setForeground(Display.getCurrent().getSystemColor(21));
        text.setToolTipText(null);
        return true;
    }

    protected String updateName(String url, String name) {
        if (url.length() > 0) {
            int common;
            if (name == null) {
                return new String(url);
            }
            if (Math.abs(url.length() - name.length()) <= 1 && name.regionMatches(0, url, 0, common = Math.min(name.length(), url.length()))) {
                return new String(url);
            }
        }
        return null;
    }
}

