package org.simantics.document.swt.core.base;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.swt.core.SWTDocument;

public abstract class WidgetContainer<C extends Control> {
	
	C control;
	
	abstract protected Control doCreateControl(SWTDocument document, Composite parent, JSONObject object);
	abstract protected void doUpdateProperties(SWTDocument document, Control control, JSONObject object);
	
	@SuppressWarnings("unchecked")
	public void createControl(SWTDocument document, Composite parent, final JSONObject object) {
		control = (C)doCreateControl(document, parent, object);
		if(control == null) {
			new Exception().printStackTrace();
			return;
		}
		doUpdateProperties(document, control, object);
	}
	
	public C getControl() {
		return (C)control;
	}
	
	@SuppressWarnings("unchecked")
	public <T> T getOrCreateControl(SWTDocument document, JSONObject object) {
		if(control == null || control.isDisposed()) {
			String parentId = object.getJSONField("parent");
			WidgetData parent = document.getWidget(parentId);
			if(parent != null) {
				WidgetContainer<?> parentContainer = (WidgetContainer<?>)parent.widget;
				Composite pc = (Composite)parentContainer.getOrCreateControl(document, parent.object);
				// TODO: pc may be disposed, how to handle this and why is it happening?
				if(pc != null && !pc.isDisposed())
					createControl(document, pc, object);
			}
		}
		return (T)control;
	}
	
	public void updateProperties(SWTDocument document, JSONObject object) {
		if(control != null) {
			doUpdateProperties(document, control, object);
		}
	}
	
}