package org.simantics.document.swt.core;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.utils.Logger;

public class DocumentComposite extends Composite {
	
	private SWTDocumentClient client;

	public DocumentComposite(Composite parent, int style, String documentUri, String inputUri) {
		super(parent, style);
		
        GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).numColumns(1).applyTo(this);
		client = new SWTDocumentClient(SWTViews.getMapping(), null, null, this);

		
		if(inputUri != null) {
			ListenerSupport support = new ListenerSupport() {

				@Override
				public void exception(Throwable t) {
					Logger.defaultLogError(t);
				}

				@Override
				public boolean isDisposed() {
					return DocumentComposite.this.isDisposed();
				}
				
			};
			
			client.track(support, documentUri, inputUri);
			layout(true, true);
		}
    	
		
	}

}
