/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import org.simantics.document.WikiDocumentNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;

public abstract class WikiDocumentNodeImpl extends ParentNode<WikiDocumentNode> implements WikiDocumentNode {

	public Boolean printInPDF = false;
	public String editText = null;
	
	private static final long serialVersionUID = 3394059912639648935L;

	static class M implements Map<String, INode> {

		ArrayList<INode> list = new ArrayList<>();
		Hashtable<String, INode> table = new Hashtable<>();

		@Override
		public void clear() {
			table.clear();
			list.clear();
		}
		@Override
		public boolean containsKey(Object arg0) {
			return table.containsKey(arg0);
		}
		@Override
		public boolean containsValue(Object arg0) {
			return table.containsValue(arg0);
		}
		@Override
		public Set<java.util.Map.Entry<String, INode>> entrySet() {
			return table.entrySet();
		}
		@Override
		public INode get(Object arg0) {
			return table.get(arg0);
		}
		@Override
		public boolean isEmpty() {
			return table.isEmpty();
		}
		@Override
		public Set<String> keySet() {
			return table.keySet();
		}
		@Override
		public INode put(String arg0, INode arg1) {
			INode exist = table.put(arg0, arg1);
			if(exist != null) list.remove(exist);
			list.add(arg1);
			return exist;
		}
		@Override
		public void putAll(Map<? extends String, ? extends INode> arg0) {
			for(Map.Entry<? extends String, ? extends INode> entry : arg0.entrySet())
				put(entry.getKey(), entry.getValue());
		}
		@Override
		public INode remove(Object arg0) {
			INode node = table.remove(arg0);
			if(node != null) list.remove(node);
			return node;
		}
		@Override
		public int size() {
			return table.size();
		}
		@Override
		public Collection<INode> values() {
			return list;
		}

	}

	@Override
	final public void asyncRemoveNode(INode node) {
        throw new Error();
	}
	
	@Override
	protected Map<String, INode> createChildMap(int initialCapacity) {
		return new M();
	}

	@Override
	public Function1<Object, Boolean> getPropertyFunction(String propertyName) {
		return ScenegraphUtils.getMethodPropertyFunction(null, this, propertyName);
	}
	
	@Override
	public <T> T getProperty(String propertyName) {
		return null;
	}
	
	@Override
	public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
	}

	protected void createChildren(StringBuilder b, boolean isPDF) {
		for(WikiDocumentNode node : getNodes()) node.create(b, isPDF);
	}
	
	public void synchronizePrintInPDF(Boolean value) {
		this.printInPDF = value;
	}
	
	protected String getName() {
		for(String id : parent.getNodeIds()) {
			if(parent.getNode(id) == this) return id;
		}
		return "err";
	}
	
	public String getPath() {
		if(parent instanceof WikiDocumentNodeImpl) {
			// Do not include root
			if(parent.getParent() == null) return "";
			else return ((WikiDocumentNodeImpl)parent).getPath() + "/" + getName(); 
		} else {
			return "";
		}
	}
	
	public void synchronizeEditText(String editText) {
		this.editText = editText;
	}
	
}
